/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.model.AbstractDomainModelUpdate;
import org.jboss.as.model.AbstractPropertyUpdate;
import org.jboss.as.model.DomainModel;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.ServerElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerSystemPropertyUpdate;
import org.jboss.as.model.UpdateFailedException;

public final class DomainSystemPropertyUpdate
extends AbstractDomainModelUpdate<Void> {
    private static final long serialVersionUID = -3412272237934071396L;
    private final AbstractPropertyUpdate propertyUpdate;

    public DomainSystemPropertyUpdate(AbstractPropertyUpdate propertyUpdate) {
        this.propertyUpdate = propertyUpdate;
    }

    @Override
    protected void applyUpdate(DomainModel element) throws UpdateFailedException {
        this.propertyUpdate.applyUpdate(element.getSystemProperties());
    }

    public DomainSystemPropertyUpdate getCompensatingUpdate(DomainModel original) {
        return new DomainSystemPropertyUpdate(this.propertyUpdate.getCompensatingUpdate(original.getSystemProperties()));
    }

    public ServerSystemPropertyUpdate getServerModelUpdate() {
        return new ServerSystemPropertyUpdate(this.propertyUpdate);
    }

    @Override
    public List<String> getAffectedServers(DomainModel domainModel, HostModel hostModel) throws UpdateFailedException {
        String propertyName = this.propertyUpdate.getPropertyName();
        if (hostModel.getSystemProperties().getPropertyNames().contains(propertyName)) {
            return Collections.emptyList();
        }
        List<String> activeServers = hostModel.getActiveServerNames();
        Iterator<String> it = activeServers.iterator();
        while (it.hasNext()) {
            ServerElement server = hostModel.getServer(it.next());
            if (server.getSystemProperties().getPropertyNames().contains(propertyName)) {
                it.remove();
                continue;
            }
            ServerGroupElement sge = domainModel.getServerGroup(server.getServerGroup());
            if (!sge.getSystemProperties().getPropertyNames().contains(propertyName)) continue;
            it.remove();
        }
        return activeServers;
    }
}

