/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.UpdateFailedException;

public final class HostJvmUpdate<R>
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String jvmName;
    private final AbstractModelUpdate<JvmElement, R> jvmUpdate;

    public static <T> HostJvmUpdate<T> create(String jvmName, AbstractModelUpdate<JvmElement, T> jvmUpdate) {
        return new HostJvmUpdate<T>(jvmName, jvmUpdate);
    }

    public HostJvmUpdate(String jvmName, AbstractModelUpdate<JvmElement, R> jvmUpdate) {
        if (jvmName == null) {
            throw new IllegalArgumentException("jvmName is null");
        }
        if (jvmUpdate == null) {
            throw new IllegalArgumentException("jvmUpdate is null");
        }
        this.jvmName = jvmName;
        this.jvmUpdate = jvmUpdate;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        JvmElement jvm = element.getJvm(this.jvmName);
        if (jvm == null) {
            throw new UpdateFailedException("Host has no JVM '" + this.jvmName + "'configured");
        }
        this.jvmUpdate.applyUpdate(jvm);
    }

    @Override
    public HostJvmUpdate<?> getCompensatingUpdate(HostModel original) {
        JvmElement jvm = original.getJvm(this.jvmName);
        if (jvm == null) {
            return null;
        }
        return HostJvmUpdate.create(this.jvmName, this.jvmUpdate.getCompensatingUpdate((AbstractModelElement)jvm));
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

