/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collections;
import java.util.List;
import org.jboss.as.model.AbstractHostModelUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.HostModel;
import org.jboss.as.model.HostRemoteDomainControllerRemove;
import org.jboss.as.model.UpdateFailedException;

public final class HostRemoteDomainControllerAdd
extends AbstractHostModelUpdate<Void> {
    private static final long serialVersionUID = 6075488950873140885L;
    private final String host;
    private final int port;

    public HostRemoteDomainControllerAdd(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    protected void applyUpdate(HostModel element) throws UpdateFailedException {
        if (!element.addRemoteDomainController(this.host, this.port)) {
            throw new UpdateFailedException("Domain controller already configured");
        }
    }

    public HostRemoteDomainControllerRemove getCompensatingUpdate(HostModel original) {
        if (original.getRemoteDomainControllerElement() != null || original.getLocalDomainControllerElement() != null) {
            return null;
        }
        return new HostRemoteDomainControllerRemove();
    }

    @Override
    public AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    @Override
    public List<String> getAffectedServers(HostModel hostModel) {
        return Collections.emptyList();
    }
}

