/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ProfileElement
extends AbstractModelElement<ProfileElement> {
    private static final long serialVersionUID = -7412521588206707920L;
    private final String name;
    private final Set<String> includedProfiles = new HashSet<String>();
    private final Map<String, AbstractSubsystemElement<? extends AbstractSubsystemElement<?>>> subsystems = new LinkedHashMap();

    public ProfileElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileElement(ProfileElement source) {
        this.name = source.name;
        Object object = source.subsystems;
        synchronized (object) {
            this.subsystems.putAll(source.subsystems);
        }
        object = source.includedProfiles;
        synchronized (object) {
            this.includedProfiles.addAll(source.includedProfiles);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIncludedProfiles() {
        Set<String> set = this.includedProfiles;
        synchronized (set) {
            return new HashSet<String>(this.includedProfiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractSubsystemElement<? extends AbstractSubsystemElement<?>>> getSubsystems() {
        Map<String, AbstractSubsystemElement<? extends AbstractSubsystemElement<?>>> map = this.subsystems;
        synchronized (map) {
            return new HashSet(this.subsystems.values());
        }
    }

    @Override
    protected Class<ProfileElement> getElementClass() {
        return ProfileElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        Object object = this.includedProfiles;
        synchronized (object) {
            if (!this.includedProfiles.isEmpty()) {
                for (String included : this.includedProfiles) {
                    streamWriter.writeEmptyElement(Element.INCLUDE.getLocalName());
                    streamWriter.writeAttribute(Attribute.PROFILE.getLocalName(), included);
                }
            }
        }
        object = this.subsystems;
        synchronized (object) {
            if (!this.subsystems.isEmpty()) {
                String defaultNamespace = streamWriter.getNamespaceContext().getNamespaceURI("");
                for (AbstractSubsystemElement<AbstractSubsystemElement<?>> subsystem : this.subsystems.values()) {
                    try {
                        QName qname = subsystem.getElementName();
                        if (streamWriter.getNamespaceContext().getPrefix(qname.getNamespaceURI()) == null) {
                            streamWriter.setDefaultNamespace(qname.getNamespaceURI());
                            streamWriter.writeStartElement(qname.getLocalPart());
                            streamWriter.writeNamespace(null, qname.getNamespaceURI());
                        } else {
                            streamWriter.writeStartElement(qname.getNamespaceURI(), qname.getLocalPart());
                        }
                        subsystem.writeContent(streamWriter);
                    }
                    finally {
                        streamWriter.setDefaultNamespace(defaultNamespace);
                    }
                }
            }
        }
        streamWriter.writeEndElement();
    }

    boolean addSubsystem(String uri, AbstractSubsystemElement<?> element) {
        assert (uri != null);
        assert (element != null);
        return this.subsystems.put(uri, element) == null;
    }

    boolean removeSubsystem(String uri) {
        return this.subsystems.remove(uri) != null;
    }

    boolean addIncludedProfile(String includedProfileName) {
        return this.includedProfiles.add(includedProfileName);
    }

    boolean removeIncludedProfile(String includedProfileName) {
        return this.includedProfiles.remove(includedProfileName);
    }

    public AbstractSubsystemElement<?> getSubsystem(String namespaceUri) {
        return this.subsystems.get(namespaceUri);
    }
}

