/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.deployment.scanner.DeploymentScannerService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentRepositoryElement;
import org.jboss.as.model.ServerDeploymentRepositoryEnable;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;

public class ServerDeploymentRepositoryDisable
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 4421499058480729575L;
    private final String path;

    public ServerDeploymentRepositoryDisable(String path) {
        super(false, true);
        this.path = path;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        DeploymentRepositoryElement repository = element.getDeploymentRepository(this.path);
        if (repository == null) {
            throw new UpdateFailedException("non existent deployment repository " + this.path);
        }
        repository.setEnabled(false);
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        return new ServerDeploymentRepositoryEnable(this.path);
    }

    @Override
    public <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = context.getServiceContainer().getService(DeploymentScannerService.getServiceName(this.path));
        if (controller == null) {
            resultHandler.handleFailure(this.notConfigured(), param);
        } else {
            try {
                DeploymentScanner scanner = (DeploymentScanner)controller.getValue();
                scanner.stopScanner();
                resultHandler.handleSuccess(null, param);
            }
            catch (Throwable t) {
                resultHandler.handleFailure(t, param);
            }
        }
    }

    private UpdateFailedException notConfigured() {
        return new UpdateFailedException("No deployment repository named " + this.path + " is configured");
    }
}

