/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.deployment.scanner.DeploymentScanner;
import org.jboss.as.deployment.scanner.DeploymentScannerService;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.DeploymentRepositoryElement;
import org.jboss.as.model.ServerDeploymentRepositoryDisable;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;

public class ServerDeploymentRepositoryEnable
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 5959855923764647668L;
    private final String name;

    public ServerDeploymentRepositoryEnable(String name) {
        super(false, true);
        this.name = name;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        DeploymentRepositoryElement repository = element.getDeploymentRepository(this.name);
        if (repository == null) {
            throw new UpdateFailedException("non existent deployment repository " + this.name);
        }
        repository.setEnabled(true);
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        return new ServerDeploymentRepositoryDisable(this.name);
    }

    @Override
    public <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = context.getServiceContainer().getService(DeploymentScannerService.getServiceName(this.name));
        if (controller == null) {
            resultHandler.handleFailure(this.notConfigured(), param);
        } else {
            try {
                DeploymentScanner scanner = (DeploymentScanner)controller.getValue();
                scanner.startScanner();
                resultHandler.handleSuccess(null, param);
            }
            catch (Throwable t) {
                resultHandler.handleFailure(t, param);
            }
        }
    }

    private UpdateFailedException notConfigured() {
        return new UpdateFailedException("No deployment repository named " + this.name + " is configured");
    }
}

