/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.Manifest;
import org.jboss.as.deployment.DeploymentFailureListener;
import org.jboss.as.deployment.DeploymentService;
import org.jboss.as.deployment.ServerDeploymentRepository;
import org.jboss.as.deployment.attachment.ManifestAttachment;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.chain.DeploymentChain;
import org.jboss.as.deployment.chain.DeploymentChainProvider;
import org.jboss.as.deployment.module.MountHandle;
import org.jboss.as.deployment.unit.DeploymentUnitContextImpl;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceActivatorContextImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.StartException;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public final class ServerDeploymentStartStopHandler
implements Serializable {
    private static final long serialVersionUID = 4804538479425267270L;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment");

    public <P> void deploy(String deploymentName, String runtimeName, byte[] deploymentHash, ServiceContainer serviceContainer, UpdateResultHandler<?, P> resultHandler, P param) {
        try {
            BatchBuilder batchBuilder = serviceContainer.batchBuilder();
            this.deploy(deploymentName, runtimeName, deploymentHash, batchBuilder, serviceContainer, resultHandler, param);
            batchBuilder.install();
        }
        catch (Exception e) {
            resultHandler.handleFailure(e, param);
        }
    }

    public <P> void deploy(String deploymentName, String runtimeName, byte[] deploymentHash, BatchBuilder batchBuilder, ServiceContainer serviceContainer, UpdateResultHandler<?, P> resultHandler, P param) {
        try {
            ServiceName deploymentServiceName = DeploymentService.getServiceName(deploymentName);
            batchBuilder.addListener(new DeploymentServiceTracker(deploymentServiceName, resultHandler, param));
            this.activate(deploymentName, runtimeName, deploymentHash, deploymentServiceName, (ServiceActivatorContext)new ServiceActivatorContextImpl(batchBuilder), serviceContainer);
        }
        catch (RuntimeException e) {
            resultHandler.handleFailure(e, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void redeploy(String deploymentName, String runtimeName, byte[] deploymentHash, ServiceContainer serviceContainer, UpdateResultHandler<?, P> resultHandler, P param) {
        block9: {
            try {
                ServiceName deploymentServiceName = DeploymentService.getServiceName(deploymentName);
                ServiceController controller = serviceContainer.getService(deploymentServiceName);
                if (controller != null && controller.getMode() != ServiceController.Mode.REMOVE) {
                    RedeploymentServiceTracker tracker = new RedeploymentServiceTracker(deploymentName);
                    controller.addListener((ServiceListener)tracker);
                    RedeploymentServiceTracker redeploymentServiceTracker = tracker;
                    synchronized (redeploymentServiceTracker) {
                        block8: {
                            controller.setMode(ServiceController.Mode.REMOVE);
                            try {
                                ((Object)((Object)tracker)).wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                if (resultHandler == null) break block8;
                                resultHandler.handleFailure(e, param);
                                return;
                            }
                        }
                    }
                }
                this.deploy(deploymentName, runtimeName, deploymentHash, serviceContainer, resultHandler, param);
            }
            catch (RuntimeException e) {
                if (resultHandler == null) break block9;
                resultHandler.handleFailure(e, param);
            }
        }
    }

    public <P> void undeploy(String deploymentName, ServiceContainer serviceContainer, UpdateResultHandler<?, P> resultHandler, P param) {
        block5: {
            try {
                ServiceName deploymentServiceName = DeploymentService.getServiceName(deploymentName);
                ServiceController controller = serviceContainer.getService(deploymentServiceName);
                if (controller != null) {
                    controller.addListener(new UndeploymentServiceTracker(deploymentName, resultHandler, param));
                    controller.setMode(ServiceController.Mode.REMOVE);
                } else if (resultHandler != null) {
                    resultHandler.handleSuccess(null, param);
                }
            }
            catch (RuntimeException e) {
                if (resultHandler == null) break block5;
                resultHandler.handleFailure(e, param);
            }
        }
    }

    private void activate(String deploymentName, String runtimeName, byte[] deploymentHash, ServiceName deploymentServiceName, ServiceActivatorContext context, ServiceContainer serviceContainer) {
        log.infof("Activating deployment: %s", (Object)deploymentName);
        MountHandle handle = null;
        try {
            ServerDeploymentRepository deploymentRepo = this.getDeploymentRepository(serviceContainer);
            VirtualFile deploymentRoot = VFS.getChild((String)("content/" + runtimeName));
            try {
                Closeable mount = deploymentRepo.mountDeploymentContent(deploymentName, runtimeName, deploymentHash, deploymentRoot);
                handle = new MountHandle(mount);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to mount deployment archive", e);
            }
            BatchBuilder batchBuilder = context.getBatchBuilder();
            DeploymentService deploymentService = new DeploymentService(handle);
            BatchServiceBuilder serviceBuilder = batchBuilder.addService(deploymentServiceName, (Service)deploymentService);
            BatchBuilder deploymentSubBatch = batchBuilder.subBatchBuilder();
            deploymentSubBatch.addDependency(deploymentServiceName);
            deploymentSubBatch.addListener((ServiceListener)new DeploymentFailureListener(deploymentServiceName));
            DeploymentUnitContextImpl deploymentUnitContext = new DeploymentUnitContextImpl(deploymentServiceName.getSimpleName(), deploymentSubBatch, (BatchServiceBuilder<Void>)serviceBuilder);
            VirtualFileAttachment.attachVirtualFile(deploymentUnitContext, deploymentRoot);
            deploymentUnitContext.putAttachment(MountHandle.ATTACHMENT_KEY, handle);
            try {
                Manifest manifest = VFSUtils.getManifest((VirtualFile)deploymentRoot);
                if (manifest != null) {
                    ManifestAttachment.attachManifest(deploymentUnitContext, manifest);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get manifest for deployment " + deploymentRoot, e);
            }
            DeploymentChainProvider deploymentChainProvider = DeploymentChainProvider.INSTANCE;
            DeploymentChain deploymentChain = deploymentChainProvider.determineDeploymentChain(deploymentUnitContext);
            log.debugf("Executing deployment '%s' with chain: %s", (Object)deploymentName, (Object)deploymentChain);
            if (deploymentChain == null) {
                throw new RuntimeException("Failed determine the deployment chain for deployment root: " + deploymentRoot);
            }
            try {
                deploymentChain.processDeployment(deploymentUnitContext);
            }
            catch (DeploymentUnitProcessingException e) {
                throw new RuntimeException("Failed to process deployment chain.", e);
            }
        }
        catch (Throwable t) {
            VFSUtils.safeClose(handle);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Failed to activate deployment unit " + deploymentName, t);
        }
    }

    private ServerDeploymentRepository getDeploymentRepository(ServiceContainer serviceContainer) throws ServiceNotFoundException {
        ServiceController serviceController = serviceContainer.getRequiredService(ServerDeploymentRepository.SERVICE_NAME);
        return (ServerDeploymentRepository)serviceController.getValue();
    }

    private static class RedeploymentServiceTracker
    extends AbstractServiceListener<Object> {
        private final String deploymentName;

        RedeploymentServiceTracker(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceController<?> controller) {
            RedeploymentServiceTracker redeploymentServiceTracker = this;
            synchronized (redeploymentServiceTracker) {
                ((Object)((Object)this)).notifyAll();
            }
            controller.removeListener((ServiceListener)this);
            log.infof("Undeployed %s", (Object)this.deploymentName);
        }
    }

    private static class UndeploymentServiceTracker<P>
    extends AbstractDeploymentServiceTracker<P> {
        private final String deploymentName;

        private UndeploymentServiceTracker(String deploymentName, UpdateResultHandler<?, P> resultHandler, P param) {
            super(resultHandler, param);
            this.deploymentName = deploymentName;
        }

        public void serviceRemoved(ServiceController<?> controller) {
            if (this.resultHandler != null) {
                this.recordResult(controller);
            }
            log.infof("Undeployed %s", (Object)this.deploymentName);
        }

        @Override
        protected boolean isCorrectService(ServiceController<?> controller) {
            return true;
        }
    }

    private static class DeploymentServiceTracker<P>
    extends AbstractDeploymentServiceTracker<P> {
        private final ServiceName deploymentServiceName;

        private DeploymentServiceTracker(ServiceName deploymentServiceName, UpdateResultHandler<?, P> resultHandler, P param) {
            super(resultHandler, param);
            assert (deploymentServiceName != null) : "deploymentServiceName is null";
            this.deploymentServiceName = deploymentServiceName;
        }

        public void serviceStarted(ServiceController<?> controller) {
            if (this.resultHandler != null && this.isCorrectService(controller)) {
                this.recordResult(controller);
            }
        }

        @Override
        protected boolean isCorrectService(ServiceController<?> controller) {
            return this.deploymentServiceName.equals(controller.getName());
        }
    }

    private static abstract class AbstractDeploymentServiceTracker<P>
    extends AbstractServiceListener<Object> {
        protected final UpdateResultHandler<?, P> resultHandler;
        protected final P param;

        protected AbstractDeploymentServiceTracker(UpdateResultHandler<?, P> resultHandler, P param) {
            this.resultHandler = resultHandler;
            this.param = param;
        }

        public void serviceFailed(ServiceController<?> controller, StartException reason) {
            if (this.resultHandler != null && this.isCorrectService(controller)) {
                this.resultHandler.handleFailure((Throwable)reason, this.param);
                controller.removeListener((ServiceListener)this);
            }
        }

        protected void recordResult(ServiceController<? extends Object> controller) {
            this.resultHandler.handleSuccess(null, this.param);
            controller.removeListener((ServiceListener)this);
        }

        protected abstract boolean isCorrectService(ServiceController<?> var1);
    }
}

