/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.Attribute;
import org.jboss.as.model.Element;
import org.jboss.as.model.JvmElement;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PropertiesElement;
import org.jboss.as.model.socket.InterfaceElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ServerElement
extends AbstractModelElement<ServerElement> {
    private static final long serialVersionUID = 7667892965813702351L;
    private final String name;
    private final String serverGroup;
    private final Map<String, InterfaceElement> interfaces = new LinkedHashMap<String, InterfaceElement>();
    private final Map<String, PathElement> paths = new LinkedHashMap<String, PathElement>();
    private boolean start;
    private String bindingGroup;
    private int portOffset = 0;
    private JvmElement jvm;
    private final PropertiesElement systemProperties = new PropertiesElement(Element.PROPERTY, true);

    public ServerElement(String name, String serverGroup) {
        this.name = name;
        this.serverGroup = serverGroup;
    }

    public boolean isStart() {
        return this.start;
    }

    void setStart(boolean start) {
        this.start = start;
    }

    public String getName() {
        return this.name;
    }

    public JvmElement getJvm() {
        return this.jvm;
    }

    void setJvm(JvmElement jvm) {
        this.jvm = jvm;
    }

    public Collection<PathElement> getPaths() {
        return Collections.unmodifiableCollection(new HashSet<PathElement>(this.paths.values()));
    }

    public PathElement getPath(String name) {
        return this.paths.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceElement getInterface(String name) {
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            return this.interfaces.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InterfaceElement> getInterfaces() {
        LinkedHashSet<InterfaceElement> intfs = new LinkedHashSet<InterfaceElement>();
        Map<String, InterfaceElement> map = this.interfaces;
        synchronized (map) {
            for (Map.Entry<String, InterfaceElement> entry : this.interfaces.entrySet()) {
                intfs.add(entry.getValue());
            }
        }
        return intfs;
    }

    public String getSocketBindingGroupName() {
        return this.bindingGroup;
    }

    public int getSocketBindingPortOffset() {
        return this.portOffset;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public PropertiesElement getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    protected Class<ServerElement> getElementClass() {
        return ServerElement.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        streamWriter.writeAttribute(Attribute.GROUP.getLocalName(), this.serverGroup);
        if (!this.start) {
            streamWriter.writeAttribute(Attribute.START.getLocalName(), "false");
        }
        Map<String, PathElement> map = this.paths;
        synchronized (map) {
            if (!this.paths.isEmpty()) {
                streamWriter.writeStartElement(Element.PATHS.getLocalName());
                for (PathElement path : this.paths.values()) {
                    streamWriter.writeStartElement(Element.PATH.getLocalName());
                    path.writeContent(streamWriter);
                }
                streamWriter.writeEndElement();
            }
        }
        if (!this.interfaces.isEmpty()) {
            streamWriter.writeStartElement(Element.INTERFACE_SPECS.getLocalName());
            for (InterfaceElement element : this.interfaces.values()) {
                streamWriter.writeStartElement(Element.INTERFACE.getLocalName());
                element.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (this.bindingGroup != null) {
            streamWriter.writeEmptyElement(Element.SOCKET_BINDING_GROUP.getLocalName());
            streamWriter.writeAttribute(Attribute.REF.getLocalName(), this.bindingGroup);
            if (this.portOffset != 0) {
                streamWriter.writeAttribute(Attribute.PORT_OFFSET.getLocalName(), String.valueOf(this.portOffset));
            }
        }
        if (this.systemProperties != null && this.systemProperties.size() > 0) {
            streamWriter.writeStartElement(Element.SYSTEM_PROPERTIES.getLocalName());
            this.systemProperties.writeContent(streamWriter);
        }
        if (this.jvm != null) {
            streamWriter.writeStartElement(Element.JVM.getLocalName());
            this.jvm.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    InterfaceElement addInterface(String name) {
        if (this.interfaces.containsKey(name)) {
            return null;
        }
        InterfaceElement networkInterface = new InterfaceElement(name);
        this.interfaces.put(name, networkInterface);
        return networkInterface;
    }

    boolean removeInterface(String name) {
        return this.interfaces.remove(name) != null;
    }

    boolean addJvm(String jvmName) {
        if (this.jvm != null) {
            return false;
        }
        this.jvm = new JvmElement(jvmName);
        return true;
    }

    void removeJvm() {
        this.jvm = null;
    }

    void setSocketBindingGroupName(String name) {
        this.bindingGroup = name;
    }

    void setSocketBindingPortOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset " + offset + " is less than zero");
        }
        this.portOffset = offset;
    }

    PathElement addPath(String name) {
        if (this.paths.containsKey(name)) {
            return null;
        }
        PathElement element = new PathElement(name);
        this.paths.put(name, element);
        return element;
    }

    boolean removePath(String name) {
        return this.paths.remove(name) != null;
    }
}

