/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractModelUpdate;
import org.jboss.as.model.ServerGroupDeploymentAdd;
import org.jboss.as.model.ServerGroupDeploymentElement;
import org.jboss.as.model.ServerGroupElement;
import org.jboss.as.model.ServerModelDeploymentRemove;
import org.jboss.as.model.UpdateFailedException;

public class ServerGroupDeploymentRemove
extends AbstractModelUpdate<ServerGroupElement, Void> {
    private static final long serialVersionUID = 5773083013951607950L;
    private final String uniqueName;

    public ServerGroupDeploymentRemove(String uniqueName) {
        if (uniqueName == null) {
            throw new IllegalArgumentException("uniqueName is null");
        }
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public ServerGroupDeploymentAdd getCompensatingUpdate(ServerGroupElement original) {
        ServerGroupDeploymentElement dep = original.getDeployment(this.uniqueName);
        return dep == null ? null : new ServerGroupDeploymentAdd(this.uniqueName, dep.getRuntimeName(), dep.getSha1Hash(), dep.isStart());
    }

    protected ServerModelDeploymentRemove getServerModelUpdate() {
        return new ServerModelDeploymentRemove(this.uniqueName);
    }

    @Override
    protected void applyUpdate(ServerGroupElement element) throws UpdateFailedException {
        if (element.getDeployment(this.uniqueName) == null) {
            throw new UpdateFailedException("Deployment " + this.uniqueName + " already removed");
        }
        element.removeDeployment(this.uniqueName);
    }

    @Override
    public Class<ServerGroupElement> getModelElementType() {
        return ServerGroupElement.class;
    }
}

