/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.PathElement;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerPathRemove;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.path.AbsolutePathService;
import org.jboss.as.services.path.RelativePathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;

public class ServerPathAdd
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = -7255447870952892481L;
    private final PathElementUpdate update;

    public ServerPathAdd(PathElementUpdate update) {
        if (update == null) {
            throw new IllegalArgumentException("null path element update");
        }
        if (update.getPath() == null) {
            throw new IllegalArgumentException("null path for path element " + update.getName());
        }
        this.update = update;
    }

    protected ServerPathAdd(PathElement element) {
        if (element.getPath() == null) {
            throw new IllegalArgumentException("null path for path element " + element.getName());
        }
        this.update = new PathElementUpdate(element.getName(), element.getPath(), element.getRelativeTo());
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        PathElement pathElement = element.addPath(this.update.getName());
        if (pathElement == null) {
            throw new UpdateFailedException("duplicate path definition " + this.update.getName());
        }
        this.update.applyUpdate(pathElement);
    }

    @Override
    public AbstractServerModelUpdate<?> getCompensatingUpdate(ServerModel original) {
        return new ServerPathRemove(this.update.getName());
    }

    @Override
    public <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        BatchBuilder batch = context.getBatchBuilder();
        BatchServiceBuilder<String> builder = this.createService(batch);
        builder.addListener(new UpdateResultHandler.ServiceStartListener<P>(resultHandler, param));
    }

    BatchServiceBuilder<String> createService(BatchBuilder batch) {
        if (this.update.isAbsolutePath()) {
            return AbsolutePathService.addService(this.update.getName(), this.update.getPath(), batch);
        }
        return RelativePathService.addService(this.update.getName(), this.update.getPath(), this.update.getRelativeTo(), batch);
    }
}

