/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model;

import org.jboss.as.model.AbstractPropertyUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;

public final class ServerSystemPropertyUpdate
extends AbstractServerModelUpdate<Void> {
    private static final long serialVersionUID = 7462989455163230095L;
    private final AbstractPropertyUpdate propertyUpdate;

    public ServerSystemPropertyUpdate(AbstractPropertyUpdate propertyUpdate) {
        this.propertyUpdate = propertyUpdate;
    }

    @Override
    protected void applyUpdate(ServerModel element) throws UpdateFailedException {
        this.propertyUpdate.applyUpdate(element.getSystemProperties());
    }

    @Override
    public <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        try {
            this.propertyUpdate.applyUpdate(System.getProperties());
        }
        catch (UpdateFailedException e) {
            resultHandler.handleFailure(e, param);
            return;
        }
        resultHandler.handleSuccess(null, param);
    }

    public ServerSystemPropertyUpdate getCompensatingUpdate(ServerModel original) {
        return new ServerSystemPropertyUpdate(this.propertyUpdate.getCompensatingUpdate(original.getSystemProperties()));
    }
}

