/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.socket;

import java.util.Set;
import org.jboss.as.model.AbstractModelElementUpdate;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.socket.SocketBindingGroupElement;

public class SocketBindingGroupUpdate
extends AbstractModelElementUpdate<SocketBindingGroupElement> {
    private static final long serialVersionUID = -7177764052517325211L;
    private final String name;
    private final String defaultInterface;
    private final Set<String> includedGroups;

    public SocketBindingGroupUpdate(String name, String defaultInterface, Set<String> includedGroups) {
        this.name = name;
        this.defaultInterface = defaultInterface;
        this.includedGroups = includedGroups;
    }

    public String getName() {
        return this.name;
    }

    protected AbstractServerModelUpdate<Void> getServerModelUpdate() {
        return null;
    }

    public SocketBindingGroupUpdate getCompensatingUpdate(SocketBindingGroupElement original) {
        return new SocketBindingGroupUpdate(this.name, original.getDefaultInterface(), original.getIncludedSocketBindingGroups());
    }

    @Override
    public Class<SocketBindingGroupElement> getModelElementType() {
        return SocketBindingGroupElement.class;
    }

    @Override
    public void applyUpdate(SocketBindingGroupElement element) throws UpdateFailedException {
        element.setDefaultInterface(this.defaultInterface);
        for (String groupName : this.includedGroups) {
            element.addIncludedGroup(groupName);
        }
    }

    public Set<String> getIncludedGroups() {
        return this.includedGroups;
    }
}

