/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.services.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.jboss.as.services.net.ManagedBinding;
import org.jboss.as.services.net.ManagedSocketBinding;
import org.jboss.as.services.net.SocketBindingManager;

class ManagedServerSocketBinding
extends ServerSocket
implements ManagedBinding {
    private final SocketBindingManager socketBindings;

    ManagedServerSocketBinding(SocketBindingManager socketBindings) throws IOException {
        this.socketBindings = socketBindings;
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return (InetSocketAddress)InetSocketAddress.class.cast(this.getLocalSocketAddress());
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        super.bind(endpoint, backlog);
        this.socketBindings.registerBinding(this);
    }

    @Override
    public Socket accept() throws IOException {
        ManagedSocketBinding socket = new ManagedSocketBinding(this.socketBindings);
        this.implAccept(socket);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.socketBindings.unregisterBinding(this);
        }
    }
}

