/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi.beans;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarOutputStream;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.jboss.as.ee.deployment.spi.DeploymentMetaData;
import org.jboss.as.ee.deployment.spi.beans.ConfigBeanXPaths;

public abstract class AbstractJBossConfigBean
implements DConfigBean {
    protected DDBean myBean;
    protected ArrayList myPropertyListeners;
    protected HashMap xpaths;
    protected DConfigBeanRoot myRoot;
    protected ConfigBeanXPaths myPath;
    protected ArrayList children;

    public AbstractJBossConfigBean(DDBean bean, DConfigBeanRoot root, ConfigBeanXPaths path) {
        this.myBean = bean;
        this.myRoot = root;
        this.myPropertyListeners = new ArrayList();
        this.xpaths = new HashMap();
        this.myPath = path;
        this.children = new ArrayList();
        ConfigBeanXPaths xpathList = this.buildXPathList();
        for (ConfigBeanXPaths x : xpathList.getChildren()) {
            this.xpaths.put(x.getPath(), x);
        }
    }

    public DDBean getDDBean() {
        return this.myBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.myPropertyListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.myPropertyListeners.remove(pcl);
    }

    public void removeDConfigBean(DConfigBean bean) throws BeanNotFoundException {
        AbstractJBossConfigBean b = (AbstractJBossConfigBean)bean;
        Object o = this.xpaths.get(b.getPath());
        if (o == null) {
            throw new BeanNotFoundException(b.getPath());
        }
        this.children.remove(bean);
        this.xpaths.remove(b.getPath());
        b.death();
    }

    public String[] getXpaths() {
        Object[] paths = this.xpaths.values().toArray();
        String[] retval = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            retval[i] = ((ConfigBeanXPaths)paths[i]).getPath();
        }
        return retval;
    }

    public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
        String path = bean.getXpath();
        ConfigBeanXPaths cPath = (ConfigBeanXPaths)this.xpaths.get(path);
        if (cPath == null) {
            return null;
        }
        JBossNullConfigBean retBean = new JBossNullConfigBean(bean, this.myRoot, cPath);
        this.children.add(retBean);
        return retBean;
    }

    public String getPath() {
        return this.myPath.getPath();
    }

    protected void death() {
        for (AbstractJBossConfigBean b : this.children) {
            try {
                this.removeDConfigBean(b);
            }
            catch (BeanNotFoundException beanNotFoundException) {}
        }
        this.xpaths.clear();
    }

    public void notifyDDChange(XpathEvent arg0) {
    }

    public void save(JarOutputStream stream, DeploymentMetaData metaData) {
    }

    protected abstract ConfigBeanXPaths buildXPathList();

    public class JBossNullConfigBean
    extends AbstractJBossConfigBean {
        public JBossNullConfigBean(DDBean bean, DConfigBeanRoot root, ConfigBeanXPaths path) {
            super(bean, root, path);
        }

        @Override
        protected ConfigBeanXPaths buildXPathList() {
            ConfigBeanXPaths pathRoot = new ConfigBeanXPaths("", null);
            return pathRoot;
        }

        @Override
        public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
            throw new ConfigurationException(bean.getXpath());
        }
    }
}

