/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentInvocationHandler;
import org.jboss.as.ee.component.ComponentLifecycle;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.ee.component.PerViewMethodInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.as.ee.component.SecurityActions;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractComponent
implements Component {
    static final Object INSTANCE_KEY = new Object();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final InterceptorInstanceFactory INSTANCE_FACTORY = new InterceptorInstanceFactory(){

        public Object createInstance(InterceptorFactoryContext context) {
            return context.getContextData().get(INSTANCE_KEY);
        }
    };
    private final String componentName;
    private final Class<?> componentClass;
    private final List<ResourceInjection> resourceInjections;
    private final List<ComponentLifecycle> postConstructMethods;
    private final List<ComponentLifecycle> preDestroyMethods;
    private final List<LifecycleInterceptorFactory> postConstructInterceptorsMethods;
    private final List<LifecycleInterceptorFactory> preDestroyInterceptorsMethods;
    private final List<ComponentInjector> componentInjectors;
    private Interceptor componentInterceptor;
    private final Map<Method, InterceptorFactory> interceptorFactoryMap;
    private final InjectedValue<NamespaceContextSelector> namespaceContextSelectorInjector = new InjectedValue();
    private final Map<Class<?>, ServiceName> viewServices;
    private volatile boolean gate;

    protected AbstractComponent(AbstractComponentConfiguration configuration) {
        this.componentName = configuration.getComponentName();
        this.componentClass = configuration.getComponentClass();
        this.resourceInjections = configuration.getResourceInjections();
        this.postConstructMethods = configuration.getPostConstructLifecycles();
        this.preDestroyMethods = configuration.getPreDestroyLifecycles();
        this.postConstructInterceptorsMethods = configuration.getPostConstructInterceptorLifecycles();
        this.preDestroyInterceptorsMethods = configuration.getPreDestroyInterceptorLifecycles();
        this.interceptorFactoryMap = configuration.getInterceptorFactoryMap();
        this.componentInjectors = configuration.getComponentInjectors();
        this.viewServices = new HashMap(configuration.getViewServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInstance createInstance() {
        if (!this.gate) {
            AbstractComponent abstractComponent = this;
            synchronized (abstractComponent) {
                while (!this.gate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Component not available (interrupted)");
                    }
                }
            }
        }
        SimpleInterceptorFactoryContext interceptorContext = new SimpleInterceptorFactoryContext();
        Object objectInstance = this.createObjectInstance();
        ArrayList<Interceptor> preDestoryInterceptors = new ArrayList<Interceptor>();
        this.createPreDestroyMethods((InterceptorFactoryContext)interceptorContext, preDestoryInterceptors);
        preDestoryInterceptors.addAll(this.applyInjections(objectInstance));
        this.performPostConstructLifecycle(objectInstance, (InterceptorFactoryContext)interceptorContext);
        AbstractComponentInstance instance = this.constructComponentInstance(objectInstance, preDestoryInterceptors, (InterceptorFactoryContext)interceptorContext);
        Map<Method, InterceptorFactory> factoryMap = this.getInterceptorFactoryMap();
        IdentityHashMap<Method, Interceptor> methodMap = new IdentityHashMap<Method, Interceptor>(factoryMap.size());
        interceptorContext.getContextData().put(INSTANCE_KEY, objectInstance);
        for (Map.Entry<Method, InterceptorFactory> entry : factoryMap.entrySet()) {
            Method method = entry.getKey();
            PerViewMethodInterceptorFactory.populate((InterceptorFactoryContext)interceptorContext, this, instance, method);
            methodMap.put(method, entry.getValue().create((InterceptorFactoryContext)interceptorContext));
        }
        instance.setMethodMap(methodMap);
        return instance;
    }

    protected Object createObjectInstance() {
        try {
            Object instance = this.componentClass.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            InstantiationError error = new InstantiationError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    protected abstract AbstractComponentInstance constructComponentInstance(Object var1, List<Interceptor> var2, InterceptorFactoryContext var3);

    @Override
    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public String getComponentName() {
        return this.componentName;
    }

    protected List<Interceptor> applyInjections(Object instance) {
        List<ResourceInjection> resourceInjections = this.resourceInjections;
        if (resourceInjections != null) {
            for (ResourceInjection resourceInjection : resourceInjections) {
                resourceInjection.inject(instance);
            }
        }
        ArrayList<ComponentInjector.InjectionHandle> injectionHandles = new ArrayList<ComponentInjector.InjectionHandle>();
        for (ComponentInjector injector : this.componentInjectors) {
            injectionHandles.add(injector.inject(instance));
        }
        return Collections.singletonList(new DisinjectionInterceptor(injectionHandles));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performPostConstructLifecycle(Object instance, InterceptorFactoryContext interceptorContext) {
        List<LifecycleInterceptorFactory> postConstructInterceptorMethods = this.postConstructInterceptorsMethods;
        if ((postConstructInterceptorMethods == null || postConstructInterceptorMethods.isEmpty()) && (this.postConstructMethods == null || this.postConstructMethods.isEmpty())) return;
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.componentClass.getClassLoader());
        try {
            for (LifecycleInterceptorFactory lifecycleInterceptorFactory : postConstructInterceptorMethods) {
                try {
                    Interceptor interceptor = lifecycleInterceptorFactory.create(interceptorContext);
                    InterceptorContext context = new InterceptorContext();
                    context.setTarget(instance);
                    context.setContextData(new HashMap());
                    context.setParameters(EMPTY_OBJECT_ARRAY);
                    interceptor.processInvocation(context);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke post construct method for class " + this.getComponentClass(), t);
                }
            }
            for (ComponentLifecycle componentLifecycle : this.postConstructMethods) {
                try {
                    componentLifecycle.invoke(instance);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke post construct method for class " + this.getComponentClass(), t);
                    return;
                }
            }
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
    }

    @Override
    public void destroyInstance(ComponentInstance instance) {
        this.performPreDestroyLifecycle(instance);
    }

    protected void createPreDestroyMethods(InterceptorFactoryContext context, List<Interceptor> interceptors) {
        for (LifecycleInterceptorFactory method : this.preDestroyInterceptorsMethods) {
            interceptors.add(method.create(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performPreDestroyLifecycle(ComponentInstance instance) {
        Iterator<Interceptor> preDestroyInterceptors = instance.getPreDestroyInterceptors().iterator();
        if (!preDestroyInterceptors.hasNext() && (this.preDestroyMethods == null || this.preDestroyMethods.isEmpty())) return;
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.componentClass.getClassLoader());
        try {
            while (preDestroyInterceptors.hasNext()) {
                try {
                    Interceptor interceptor = preDestroyInterceptors.next();
                    InterceptorContext context = new InterceptorContext();
                    context.setTarget((Object)instance);
                    context.setContextData(new HashMap());
                    context.setParameters(EMPTY_OBJECT_ARRAY);
                    interceptor.processInvocation(context);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke post construct method for class " + this.getComponentClass(), t);
                }
            }
            for (ComponentLifecycle preDestroyMethod : this.preDestroyMethods) {
                try {
                    preDestroyMethod.invoke(instance);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke pre destroy method for class " + this.getComponentClass(), t);
                    return;
                }
            }
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
    }

    public List<ResourceInjection> getResourceInjections() {
        return Collections.unmodifiableList(this.resourceInjections);
    }

    @Override
    public ComponentInvocationHandler createClient(Class<?> viewClass) {
        return null;
    }

    @Override
    public NamespaceContextSelector getNamespaceContextSelector() {
        return (NamespaceContextSelector)this.namespaceContextSelectorInjector.getValue();
    }

    InjectedValue<NamespaceContextSelector> getNamespaceContextSelectorInjector() {
        return this.namespaceContextSelectorInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        AbstractComponent abstractComponent = this;
        synchronized (abstractComponent) {
            this.gate = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AbstractComponent abstractComponent = this;
        synchronized (abstractComponent) {
            this.gate = false;
        }
    }

    Map<Method, InterceptorFactory> getInterceptorFactoryMap() {
        return this.interceptorFactoryMap;
    }

    @Override
    public Object createRemoteProxy(Class<?> view, ClassLoader targetClassLoader, Interceptor clientInterceptor) {
        throw new UnsupportedOperationException("One thing at a time!");
    }

    Interceptor getComponentInterceptor() {
        assert (this.componentInterceptor != null) : "componentInterceptor is null";
        return this.componentInterceptor;
    }

    void setComponentInterceptor(Interceptor interceptor) {
        this.componentInterceptor = interceptor;
    }

    @Override
    public Map<Class<?>, ServiceName> getViewServices() {
        return Collections.unmodifiableMap(this.viewServices);
    }

    private static class DisinjectionInterceptor
    implements Interceptor {
        private final List<ComponentInjector.InjectionHandle> injections;

        public DisinjectionInterceptor(List<ComponentInjector.InjectionHandle> injections) {
            this.injections = injections;
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            for (ComponentInjector.InjectionHandle injectionHandle : this.injections) {
                injectionHandle.uninject();
            }
            return null;
        }
    }
}

