/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import java.util.Map;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ComponentInterceptorAnnotationParsingProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName INTERCEPTORS_ANNOTATION_NAME = DotName.createSimple((String)Interceptors.class.getName());
    private static final DotName EXCLUDE_DEFAULT_ANNOTATION_NAME = DotName.createSimple((String)ExcludeDefaultInterceptors.class.getName());
    private static final DotName EXCLUDE_CLASS_ANNOTATION_NAME = DotName.createSimple((String)ExcludeClassInterceptors.class.getName());

    @Override
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)componentConfiguration.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        this.processInterceptorConfigs(classInfo, classInfo.name().toString(), index, componentConfiguration, true);
    }

    private void processInterceptorConfigs(ClassInfo classInfo, String actualClassName, CompositeIndex index, AbstractComponentDescription componentConfiguration, boolean actualClass) throws DeploymentUnitProcessingException {
        List interceptorAnnotations;
        List excludeClassAnnotations;
        Map classAnnotations;
        ClassInfo superClassInfo = index.getClassByName(classInfo.superName());
        String className = classInfo.name().toString();
        if (superClassInfo != null) {
            this.processInterceptorConfigs(superClassInfo, actualClassName, index, componentConfiguration, false);
        }
        if ((classAnnotations = classInfo.annotations()) == null) {
            return;
        }
        List excludeDefaultAnnotations = (List)classAnnotations.get(EXCLUDE_DEFAULT_ANNOTATION_NAME);
        if (excludeDefaultAnnotations != null) {
            for (AnnotationInstance annotation : excludeDefaultAnnotations) {
                AnnotationTarget target = annotation.target();
                if (target instanceof MethodInfo) {
                    MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
                    MethodIdentifier methodIdentifier = ComponentInterceptorAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo);
                    componentConfiguration.excludeDefaultInterceptors(methodIdentifier);
                    continue;
                }
                componentConfiguration.setExcludeDefaultInterceptors(true);
            }
        }
        if ((excludeClassAnnotations = (List)classAnnotations.get(EXCLUDE_CLASS_ANNOTATION_NAME)) != null) {
            for (AnnotationInstance annotation : excludeDefaultAnnotations) {
                AnnotationTarget target = annotation.target();
                if (target instanceof MethodInfo) {
                    MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
                    MethodIdentifier methodIdentifier = ComponentInterceptorAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo);
                    componentConfiguration.excludeClassInterceptors(methodIdentifier);
                    continue;
                }
                throw new DeploymentUnitProcessingException("ExcludeClassInterceptors not applied to method: " + target);
            }
        }
        if ((interceptorAnnotations = (List)classAnnotations.get(INTERCEPTORS_ANNOTATION_NAME)) == null || interceptorAnnotations.isEmpty()) {
            return;
        }
        for (AnnotationInstance annotationInstance : interceptorAnnotations) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            for (Type interceptorClass : value.asClassArray()) {
                ClassInfo interceptorClassInfo = index.getClassByName(interceptorClass.name());
                if (interceptorClassInfo == null) continue;
                AnnotationTarget target = annotationInstance.target();
                if (target instanceof MethodInfo) {
                    MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
                    componentConfiguration.addMethodInterceptor(ComponentInterceptorAnnotationParsingProcessor.methodIdentifierFromMethodInfo(methodInfo), new InterceptorDescription(interceptorClassInfo.name().toString()));
                    continue;
                }
                if (!actualClass) continue;
                componentConfiguration.addClassInterceptor(new InterceptorDescription(interceptorClassInfo.name().toString()));
            }
        }
    }

    private static MethodIdentifier methodIdentifierFromMethodInfo(MethodInfo methodInfo) {
        String[] argTypes = new String[methodInfo.args().length];
        int i = 0;
        for (Type argType : methodInfo.args()) {
            argTypes[i++] = argType.name().toString();
        }
        return MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
    }
}

