/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorMethodDescription {
    private final MethodIdentifier identifier;
    private final String declaringClass;
    private final String instanceClass;
    private final boolean declaredOnTargetClass;

    public InterceptorMethodDescription(String declaringClass, String instanceClass, MethodIdentifier identifier, boolean declaredOnTargetClass) {
        this.declaringClass = declaringClass;
        this.identifier = identifier;
        this.declaredOnTargetClass = declaredOnTargetClass;
        this.instanceClass = instanceClass;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }

    public MethodIdentifier getIdentifier() {
        return this.identifier;
    }

    public static InterceptorMethodDescription create(String declaringClass, String instanceClass, MethodInfo methodInfo, boolean declaredOnTargetClass) {
        String[] argTypes = new String[methodInfo.args().length];
        int i = 0;
        for (Type argType : methodInfo.args()) {
            argTypes[i++] = argType.name().toString();
        }
        MethodIdentifier identifier = MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
        return new InterceptorMethodDescription(declaringClass, instanceClass, identifier, declaredOnTargetClass);
    }

    public boolean isDeclaredOnTargetClass() {
        return this.declaredOnTargetClass;
    }
}

