/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.ComponentLifecycle;
import org.jboss.as.ee.component.ComponentLifecycleMethod;
import org.jboss.as.ee.component.InterceptorMethodDescription;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.MethodInterceptorFactory;
import org.jboss.invocation.SimpleInterceptorInstanceFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class LifecycleInterceptorBuilder {
    public static void createLifecycleInterceptors(AbstractComponentDescription description, AbstractComponentConfiguration componentConfiguration, Module module, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ModuleClassLoader classLoader = module.getClassLoader();
        for (InterceptorMethodDescription lifecycleConfiguration : description.getPostConstructs()) {
            try {
                if (lifecycleConfiguration.isDeclaredOnTargetClass()) {
                    componentConfiguration.addPostConstructLifecycle(LifecycleInterceptorBuilder.createLifecycle((ClassLoader)classLoader, componentConfiguration, lifecycleConfiguration, deploymentReflectionIndex));
                    continue;
                }
                componentConfiguration.addPostConstructInterceptorLifecycle(LifecycleInterceptorBuilder.createInterceptorLifecycle((ClassLoader)classLoader, componentConfiguration, lifecycleConfiguration, deploymentReflectionIndex));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to create lifecycle interceptor instance: " + lifecycleConfiguration.getIdentifier().getName(), (Throwable)e);
            }
        }
        for (InterceptorMethodDescription lifecycleConfiguration : description.getPreDestroys()) {
            try {
                if (lifecycleConfiguration.isDeclaredOnTargetClass()) {
                    componentConfiguration.addPreDestroyLifecycle(LifecycleInterceptorBuilder.createLifecycle((ClassLoader)classLoader, componentConfiguration, lifecycleConfiguration, deploymentReflectionIndex));
                    continue;
                }
                componentConfiguration.addPreDestroyInterceptorLifecycle(LifecycleInterceptorBuilder.createInterceptorLifecycle((ClassLoader)classLoader, componentConfiguration, lifecycleConfiguration, deploymentReflectionIndex));
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to create lifecycle interceptor instance: " + lifecycleConfiguration.getIdentifier().getName(), (Throwable)e);
            }
        }
    }

    private static ComponentLifecycle createLifecycle(ClassLoader classLoader, AbstractComponentConfiguration componentConfiguration, InterceptorMethodDescription lifecycleConfiguration, DeploymentReflectionIndex deploymentReflectionIndex) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> interceptorClass = classLoader.loadClass(lifecycleConfiguration.getDeclaringClass());
        Method lifecycleMethod = deploymentReflectionIndex.getClassIndex(interceptorClass).getMethod(Void.TYPE, lifecycleConfiguration.getIdentifier().getName(), new Class[0]);
        return new ComponentLifecycleMethod(lifecycleMethod);
    }

    private static LifecycleInterceptorFactory createInterceptorLifecycle(ClassLoader classLoader, AbstractComponentConfiguration componentConfiguration, InterceptorMethodDescription lifecycleConfiguration, DeploymentReflectionIndex deploymentReflectionIndex) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> declaringClass = classLoader.loadClass(lifecycleConfiguration.getDeclaringClass());
        Class<?> instanceClass = classLoader.loadClass(lifecycleConfiguration.getInstanceClass());
        Method lifecycleMethod = deploymentReflectionIndex.getClassIndex(declaringClass).getMethod(Void.TYPE, lifecycleConfiguration.getIdentifier().getName(), new Class[]{InvocationContext.class});
        MethodInterceptorFactory delegate = new MethodInterceptorFactory((InterceptorInstanceFactory)new SimpleInterceptorInstanceFactory(instanceClass), lifecycleMethod);
        return new LifecycleInterceptorFactory((InterceptorFactory)delegate, lifecycleMethod);
    }
}

