/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.as.ee.component.FieldResourceInjection;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.MethodResourceInjection;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.msc.value.Value;

public interface ResourceInjection {
    public void inject(Object var1);

    public static class Factory {
        private Factory() {
        }

        public static ResourceInjection create(InjectionTargetDescription resourceConfiguration, Class<?> beanClass, ClassReflectionIndex<?> reflectionIndex, Value<ManagedReferenceFactory> value) {
            Class<?> argClass;
            try {
                argClass = beanClass.getClassLoader().loadClass(resourceConfiguration.getValueClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid resource injection configuration.", e);
            }
            String memberName = resourceConfiguration.getName();
            switch (resourceConfiguration.getType()) {
                case FIELD: {
                    Field field = reflectionIndex.getField(memberName);
                    if (field == null || !field.getType().isAssignableFrom(argClass)) {
                        throw new IllegalArgumentException("Invalid injection into field '" + memberName + "' of " + beanClass);
                    }
                    return new FieldResourceInjection(field, value);
                }
                case METHOD: {
                    Method method = reflectionIndex.getMethod(Void.TYPE, memberName, new Class[]{argClass});
                    if (method == null || !method.getParameterTypes()[0].isAssignableFrom(argClass)) {
                        throw new IllegalArgumentException("Invalid injection into method '" + memberName + "' of " + beanClass);
                    }
                    return new MethodResourceInjection(method, value);
                }
            }
            throw new IllegalStateException();
        }
    }
}

