/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.ee.component.LookupBindingSourceDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public class ResourceInjectionAnnotationParsingProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName RESOURCES_ANNOTATION_NAME = DotName.createSimple((String)Resources.class.getName());
    private static final Map<String, String> FIXED_LOCATIONS;

    @Override
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription componentDescription) {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)componentDescription.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        componentDescription.getBindings().addAll(this.getResourceConfigurations(classInfo));
        Collection<InterceptorDescription> interceptorConfigurations = componentDescription.getAllInterceptors().values();
        for (InterceptorDescription interceptorConfiguration : interceptorConfigurations) {
            ClassInfo interceptorClassInfo = index.getClassByName(DotName.createSimple((String)interceptorConfiguration.getInterceptorClassName()));
            if (interceptorClassInfo == null) continue;
            interceptorConfiguration.getBindings().addAll(this.getResourceConfigurations(interceptorClassInfo));
        }
    }

    private List<BindingDescription> getResourceConfigurations(ClassInfo classInfo) {
        ArrayList<BindingDescription> configurations = new ArrayList<BindingDescription>();
        Map classAnnotations = classInfo.annotations();
        if (classAnnotations != null) {
            List resourceAnnotations = (List)classAnnotations.get(RESOURCE_ANNOTATION_NAME);
            if (resourceAnnotations != null) {
                for (AnnotationInstance annotation : resourceAnnotations) {
                    configurations.add(this.getResourceConfiguration(annotation));
                }
            }
            configurations.addAll(this.processClassResources(classAnnotations));
        }
        return configurations;
    }

    private BindingDescription getResourceConfiguration(AnnotationInstance annotation) {
        String type;
        AnnotationTarget annotationTarget = annotation.target();
        AnnotationValue nameValue = annotation.value("name");
        String name = nameValue != null ? nameValue.asString() : null;
        AnnotationValue typeValue = annotation.value("type");
        String string = type = typeValue != null ? typeValue.asClass().name().toString() : null;
        BindingDescription resourceConfiguration = annotationTarget instanceof FieldInfo ? this.processFieldResource((FieldInfo)FieldInfo.class.cast(annotationTarget), name, type) : (annotationTarget instanceof MethodInfo ? this.processMethodResource((MethodInfo)MethodInfo.class.cast(annotationTarget), name, type) : (annotationTarget instanceof ClassInfo ? this.processClassResource(name, type) : null));
        if (resourceConfiguration != null) {
            AnnotationValue description = annotation.value("description");
            if (description != null) {
                resourceConfiguration.setDescription(description.asString());
            }
            String bindingType = resourceConfiguration.getBindingType();
            AnnotationValue lookupValue = annotation.value("lookup");
            if (lookupValue != null) {
                resourceConfiguration.setReferenceSourceDescription(new LookupBindingSourceDescription(lookupValue.asString()));
            } else if (FIXED_LOCATIONS.containsKey(bindingType)) {
                resourceConfiguration.setReferenceSourceDescription(new LookupBindingSourceDescription(FIXED_LOCATIONS.get(bindingType)));
            } else {
                resourceConfiguration.setReferenceSourceDescription(new LazyBindingSourceDescription());
            }
        }
        return resourceConfiguration;
    }

    private BindingDescription processFieldResource(FieldInfo fieldInfo, String name, String type) {
        String fieldName = fieldInfo.name();
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? fieldInfo.type().name().toString() : type;
        String localContextName = this.isEmpty(name) ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : name;
        BindingDescription bindingDescription = this.createBindingDescription(localContextName, injectionType);
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(fieldName);
        targetDescription.setClassName(fieldInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.FIELD);
        targetDescription.setValueClassName(injectionType);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processMethodResource(MethodInfo methodInfo, String name, String type) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@Resource injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        String localContextName = name == null || name.isEmpty() ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : name;
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : type;
        BindingDescription bindingDescription = this.createBindingDescription(localContextName, injectionType);
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(methodName);
        targetDescription.setClassName(methodInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.METHOD);
        targetDescription.setValueClassName(injectionType);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processClassResource(String name, String type) {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("Class level @Resource annotations must provide a name.");
        }
        if (this.isEmpty(type) || type.equals(Object.class.getName())) {
            throw new IllegalArgumentException("Class level @Resource annotations must provide a type.");
        }
        return this.createBindingDescription(name, type);
    }

    private List<BindingDescription> processClassResources(Map<DotName, List<AnnotationInstance>> classAnnotations) {
        List<AnnotationInstance> resourcesAnnotations = classAnnotations.get(RESOURCES_ANNOTATION_NAME);
        if (resourcesAnnotations == null || resourcesAnnotations.isEmpty()) {
            return Collections.emptyList();
        }
        AnnotationInstance resourcesInstance = resourcesAnnotations.get(0);
        AnnotationInstance[] resourceAnnotations = resourcesInstance.value().asNestedArray();
        ArrayList<BindingDescription> resourceConfigurations = new ArrayList<BindingDescription>(resourceAnnotations.length);
        for (AnnotationInstance resource : resourceAnnotations) {
            resourceConfigurations.add(this.getResourceConfiguration(resource));
        }
        return resourceConfigurations;
    }

    private BindingDescription createBindingDescription(String name, String beanInterface) {
        BindingDescription bindingDescription = new BindingDescription();
        bindingDescription.setDependency(true);
        bindingDescription.setBindingName(name);
        bindingDescription.setBindingType(beanInterface);
        return bindingDescription;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static {
        HashMap<String, String> locations = new HashMap<String, String>();
        locations.put("javax.transaction.UserTransaction", "java:comp/UserTransaction");
        locations.put("javax.transaction.TransactionSynchronizationRegistry", "java:comp/TransactionSynchronizationRegistry");
        locations.put("javax.enterprise.inject.spi.BeanManager", "java:comp/BeanManager");
        locations.put("javax.validation.Validator", "java:comp/Validator");
        locations.put("javax.validation.ValidationFactory", "java:comp/ValidationFactory");
        locations.put("javax.ejb.EJBContext", "java:comp/EJBContext");
        locations.put("javax.ejb.SessionContext", "java:comp/EJBContext");
        locations.put("org.omg.CORBA.ORB", "java:comp/ORB");
        FIXED_LOCATIONS = Collections.unmodifiableMap(locations);
    }
}

