/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractLifecycleCapableDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingsContainer;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectingInterceptorInstanceFactory;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.InterceptorMethodDescription;
import org.jboss.as.ee.component.LifecycleInterceptorBuilder;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.MethodInterceptorFactory;
import org.jboss.invocation.MethodInvokingInterceptorFactory;
import org.jboss.invocation.SimpleInterceptorInstanceFactory;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractComponentDescription
extends AbstractLifecycleCapableDescription {
    private final String componentName;
    private final String moduleName;
    private final String applicationName;
    private final String componentClassName;
    private final EEModuleDescription moduleDescription;
    private final Map<String, InterceptorMethodDescription> aroundInvokeMethods = new LinkedHashMap<String, InterceptorMethodDescription>();
    private final List<InterceptorDescription> classInterceptors = new ArrayList<InterceptorDescription>();
    private final Set<String> classInterceptorsSet = new HashSet<String>();
    private final List<InterceptorFactory> interceptorFactories = new ArrayList<InterceptorFactory>();
    private final Map<MethodIdentifier, List<InterceptorDescription>> methodInterceptors = new HashMap<MethodIdentifier, List<InterceptorDescription>>();
    private final Map<MethodIdentifier, Set<String>> methodInterceptorsSet = new HashMap<MethodIdentifier, Set<String>>();
    private final Set<MethodIdentifier> methodExcludeDefaultInterceptors = new HashSet<MethodIdentifier>();
    private final Set<MethodIdentifier> methodExcludeClassInterceptors = new HashSet<MethodIdentifier>();
    private final Map<String, InterceptorDescription> allInterceptors = new HashMap<String, InterceptorDescription>();
    private final Map<ServiceName, ServiceBuilder.DependencyType> dependencies = new HashMap<ServiceName, ServiceBuilder.DependencyType>();
    private final Set<String> viewClassNames = new HashSet<String>();
    private ComponentNamingMode namingMode = ComponentNamingMode.NONE;
    private boolean excludeDefaultInterceptors = false;
    private final BindingsContainer bindingsContainer;
    private DeploymentDescriptorEnvironment deploymentDescriptorEnvironment;
    private static final AtomicInteger seq = new AtomicInteger();

    protected AbstractComponentDescription(String componentName, String componentClassName, EEModuleDescription module) {
        this.moduleName = module.getModuleName();
        this.applicationName = module.getAppName();
        this.moduleDescription = module;
        if (componentName == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (componentClassName == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (module == null) {
            throw new IllegalArgumentException("moduleName is null");
        }
        if (this.applicationName == null) {
            throw new IllegalArgumentException("applicationName is null");
        }
        this.componentName = componentName;
        this.componentClassName = componentClassName;
        this.bindingsContainer = new BindingsContainer();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public List<InterceptorDescription> getClassInterceptors() {
        return this.classInterceptors;
    }

    public Map<String, InterceptorDescription> getAllInterceptors() {
        return this.allInterceptors;
    }

    public boolean isExcludeDefaultInterceptors() {
        return this.excludeDefaultInterceptors;
    }

    public void setExcludeDefaultInterceptors(boolean excludeDefaultInterceptors) {
        this.excludeDefaultInterceptors = excludeDefaultInterceptors;
    }

    public void excludeDefaultInterceptors(MethodIdentifier method) {
        this.methodExcludeDefaultInterceptors.add(method);
    }

    public void excludeClassInterceptors(MethodIdentifier method) {
        this.methodExcludeClassInterceptors.add(method);
    }

    public void addInterceptorFactory(InterceptorFactory factory) {
        this.interceptorFactories.add(factory);
    }

    public boolean addClassInterceptor(InterceptorDescription description) {
        String name = description.getInterceptorClassName();
        if (this.classInterceptorsSet.contains(name)) {
            return false;
        }
        if (!this.allInterceptors.containsKey(name)) {
            this.allInterceptors.put(name, description);
        }
        this.classInterceptors.add(description);
        this.classInterceptorsSet.add(name);
        return true;
    }

    public InterceptorDescription getClassInterceptor(String interceptorClassName) {
        if (!this.classInterceptorsSet.contains(interceptorClassName)) {
            return null;
        }
        for (InterceptorDescription interceptor : this.classInterceptors) {
            if (!interceptor.getInterceptorClassName().equals(interceptorClassName)) continue;
            return interceptor;
        }
        return null;
    }

    public Map<MethodIdentifier, List<InterceptorDescription>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public boolean addMethodInterceptor(MethodIdentifier method, InterceptorDescription description) {
        String name;
        List<InterceptorDescription> interceptors = this.methodInterceptors.get(method);
        Set<String> interceptorClasses = this.methodInterceptorsSet.get(method);
        if (interceptors == null) {
            interceptors = new ArrayList<InterceptorDescription>();
            this.methodInterceptors.put(method, interceptors);
            interceptorClasses = new HashSet<String>();
            this.methodInterceptorsSet.put(method, interceptorClasses);
        }
        if (interceptorClasses.contains(name = description.getInterceptorClassName())) {
            return false;
        }
        if (!this.allInterceptors.containsKey(name)) {
            this.allInterceptors.put(name, description);
        }
        interceptors.add(description);
        interceptorClasses.add(name);
        return true;
    }

    public void addAroundInvokeMethod(InterceptorMethodDescription methodDescription) {
        String declaringClassName = methodDescription.getDeclaringClass();
        if (this.aroundInvokeMethods.containsKey(declaringClassName)) {
            throw new IllegalArgumentException("Only one @AroundInvoke method allowed per class: " + declaringClassName);
        }
        this.aroundInvokeMethods.put(declaringClassName, methodDescription);
    }

    public ComponentNamingMode getNamingMode() {
        return this.namingMode;
    }

    public void setNamingMode(ComponentNamingMode namingMode) {
        if (namingMode == null) {
            throw new IllegalArgumentException("namingMode is null");
        }
        this.namingMode = namingMode;
    }

    public Set<String> getViewClassNames() {
        return this.viewClassNames;
    }

    public void addDependency(ServiceName serviceName, ServiceBuilder.DependencyType type) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        Map<ServiceName, ServiceBuilder.DependencyType> dependencies = this.dependencies;
        ServiceBuilder.DependencyType dependencyType = dependencies.get(serviceName);
        if (dependencyType == ServiceBuilder.DependencyType.REQUIRED) {
            dependencies.put(serviceName, ServiceBuilder.DependencyType.REQUIRED);
        } else {
            dependencies.put(serviceName, type);
        }
    }

    public final AbstractComponentConfiguration createComponentConfiguration(DeploymentPhaseContext phaseContext, Class<?> componentClass) throws DeploymentUnitProcessingException {
        AbstractComponentConfiguration configuration = this.constructComponentConfiguration();
        configuration.setComponentClass(componentClass);
        this.prepareComponentConfiguration(configuration, phaseContext);
        return configuration;
    }

    protected abstract AbstractComponentConfiguration constructComponentConfiguration();

    protected void prepareComponentConfiguration(AbstractComponentConfiguration configuration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        HashMap<MethodIdentifier, Method> componentMethods = new HashMap<MethodIdentifier, Method>();
        IdentityHashMap<Method, InterceptorFactory> componentToInterceptorFactory = new IdentityHashMap<Method, InterceptorFactory>();
        Class<?> componentClass = configuration.getComponentClass();
        ClassReflectionIndex classIndex = index.getClassIndex(componentClass);
        for (Method componentMethod : classIndex.getMethods()) {
            List<InterceptorDescription> methodLevelInterceptors;
            MethodIdentifier methodIdentifier = MethodIdentifier.getIdentifierForMethod((Method)componentMethod);
            int modifiers = componentMethod.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            componentMethods.put(MethodIdentifier.getIdentifierForMethod((Method)componentMethod), componentMethod);
            ArrayList<InterceptorFactory> theInterceptorFactories = new ArrayList<InterceptorFactory>();
            theInterceptorFactories.addAll(configuration.getComponentInstanceSystemInterceptorFactories());
            if (!this.methodExcludeClassInterceptors.contains(methodIdentifier)) {
                for (InterceptorDescription interceptor : this.classInterceptors) {
                    this.registerComponentInterceptor(interceptor, configuration, module, index, theInterceptorFactories);
                }
            }
            if ((methodLevelInterceptors = this.methodInterceptors.get(methodIdentifier)) != null) {
                for (InterceptorDescription interceptorDescription : methodLevelInterceptors) {
                    this.registerComponentInterceptor(interceptorDescription, configuration, module, index, theInterceptorFactories);
                }
            }
            for (Map.Entry entry : this.aroundInvokeMethods.entrySet()) {
                try {
                    InterceptorMethodDescription aroundInvoke = (InterceptorMethodDescription)entry.getValue();
                    Class methodDeclaringClass = module.getClassLoader().loadClass((String)entry.getKey());
                    ClassReflectionIndex methodDeclaringClassIndex = index.getClassIndex(methodDeclaringClass);
                    Method aroundInvokeMethod = methodDeclaringClassIndex.getMethod(Object.class, aroundInvoke.getIdentifier().getName(), new Class[]{InvocationContext.class});
                    theInterceptorFactories.add((InterceptorFactory)new MethodInterceptorFactory(AbstractComponent.INSTANCE_FACTORY, aroundInvokeMethod));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Failed to load interceptor class " + (String)entry.getKey());
                }
            }
            theInterceptorFactories.addAll(this.interceptorFactories);
            theInterceptorFactories.add((InterceptorFactory)new MethodInvokingInterceptorFactory(AbstractComponent.INSTANCE_FACTORY, componentMethod));
            componentToInterceptorFactory.put(componentMethod, Interceptors.getChainedInterceptorFactory(theInterceptorFactories));
            this.processComponentMethod(configuration, componentMethod);
        }
        configuration.addPostConstructComponentLifecycles(this.getPostConstructComponentLifecycles());
        configuration.addPostConstructComponentLifecycles(LifecycleInterceptorBuilder.createLifecycless(this.getPostConstructs(), module, index));
        configuration.addPreDestroyComponentLifecycles(LifecycleInterceptorBuilder.createLifecycless(this.getPreDestroys(), module, index));
        configuration.addPostConstructLifecycles(LifecycleInterceptorBuilder.createLifecycleInterceptors(this.getPostConstructs(), module, index));
        configuration.addPreDestroyLifecycles(LifecycleInterceptorBuilder.createLifecycleInterceptors(this.getPreDestroys(), module, index));
        configuration.addPreDestroyComponentLifecycles(this.getPreDestroyComponentLifecycles());
        Map<Class<?>, List<LifecycleInterceptorFactory>> interceptorPreDestroys = configuration.getInterceptorPreDestroys();
        for (InterceptorDescription interceptorDescription : this.getClassInterceptors()) {
            Class<?> interceptorClass;
            try {
                interceptorClass = Class.forName(interceptorDescription.getInterceptorClassName(), false, componentClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Failed to load interceptor class " + interceptorDescription.getInterceptorClassName(), (Throwable)e);
            }
            interceptorPreDestroys.put(interceptorClass, LifecycleInterceptorBuilder.createLifecycleInterceptors(interceptorDescription.getPreDestroys(), module, index));
        }
        Map<Method, InterceptorFactory> viewToInterceptorFactory = configuration.getInterceptorFactoryMap();
        for (Method componentMethod : classIndex.getMethods()) {
            int modifiers;
            if (componentMethod.getDeclaringClass().equals(Object.class) || Modifier.isStatic(modifiers = componentMethod.getModifiers()) || Modifier.isFinal(modifiers)) continue;
            InterceptorFactory interceptorFactory = (InterceptorFactory)componentToInterceptorFactory.get(componentMethod);
            assert (interceptorFactory != null) : "Can't find interceptor factory for " + componentMethod;
            viewToInterceptorFactory.put(componentMethod, interceptorFactory);
        }
        configuration.setComponentMethods(classIndex.getMethods());
        Map<Class<?>, ProxyFactory<?>> proxyFactories = configuration.getProxyFactories();
        for (String viewClassName : this.viewClassNames) {
            Class<?> viewClass;
            try {
                viewClass = Class.forName(viewClassName, false, componentClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Failed to load view class " + viewClassName, (Throwable)e);
            }
            ProxyFactory<?> factory = AbstractComponentDescription.getProxyFactory(viewClass);
            proxyFactories.put(viewClass, factory);
            for (Method viewMethod : factory.getCachedMethods()) {
                Method componentMethod = (Method)componentMethods.get(MethodIdentifier.getIdentifierForMethod((Method)viewMethod));
                if (componentMethod != null) {
                    viewToInterceptorFactory.put(viewMethod, (InterceptorFactory)componentToInterceptorFactory.get(componentMethod));
                }
                this.processViewMethod(configuration, viewClass, viewMethod, componentMethod);
            }
        }
        Map<ServiceName, InjectedValue<Object>> dependencyInjections = configuration.getDependencyInjections();
        for (Map.Entry<ServiceName, ServiceBuilder.DependencyType> entry : this.dependencies.entrySet()) {
            InjectedValue value = new InjectedValue();
            dependencyInjections.put(entry.getKey(), (InjectedValue<Object>)value);
        }
    }

    public Map<ServiceName, ServiceBuilder.DependencyType> getDependencies() {
        return this.dependencies;
    }

    protected void processComponentMethod(AbstractComponentConfiguration configuration, Method componentMethod) throws DeploymentUnitProcessingException {
    }

    protected void processViewMethod(AbstractComponentConfiguration configuration, Class<?> viewClass, Method viewMethod, Method componentMethod) {
    }

    private void registerComponentInterceptor(InterceptorDescription interceptor, AbstractComponentConfiguration configuration, Module module, DeploymentReflectionIndex index, List<InterceptorFactory> theInterceptorFactories) throws DeploymentUnitProcessingException {
        try {
            Class interceptorClass = module.getClassLoader().loadClass(interceptor.getInterceptorClassName());
            List<LifecycleInterceptorFactory> postConstructs = LifecycleInterceptorBuilder.createLifecycleInterceptors(interceptor.getPostConstructs(), module, index);
            List<LifecycleInterceptorFactory> preDestroys = LifecycleInterceptorBuilder.createLifecycleInterceptors(interceptor.getPreDestroys(), module, index);
            InjectingInterceptorInstanceFactory instanceFactory = new InjectingInterceptorInstanceFactory(new SimpleInterceptorInstanceFactory(interceptorClass), interceptorClass, configuration, postConstructs, preDestroys);
            for (InterceptorMethodDescription aroundInvoke : interceptor.getAroundInvokeMethods()) {
                Class methodDeclaringClass = module.getClassLoader().loadClass(aroundInvoke.getDeclaringClass());
                ClassReflectionIndex methodDeclaringClassIndex = index.getClassIndex(methodDeclaringClass);
                Method aroundInvokeMethod = methodDeclaringClassIndex.getMethod(Object.class, aroundInvoke.getIdentifier().getName(), new Class[]{InvocationContext.class});
                theInterceptorFactories.add((InterceptorFactory)new MethodInterceptorFactory((InterceptorInstanceFactory)instanceFactory, aroundInvokeMethod));
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Failed to load interceptor class " + interceptor.getInterceptorClassName());
        }
    }

    public void addAnnotationBinding(BindingDescription binding) {
        if (this.getNamingMode() != ComponentNamingMode.CREATE || binding.getBindingName() == null || !binding.getBindingName().startsWith("java:comp")) {
            this.moduleDescription.getBindingsContainer().addAnnotationBinding(binding);
        } else {
            this.bindingsContainer.addAnnotationBinding(binding);
        }
    }

    public void addBinding(BindingDescription binding) {
        if (this.getNamingMode() != ComponentNamingMode.CREATE || binding.getBindingName() == null || !binding.getBindingName().startsWith("java:comp")) {
            this.moduleDescription.getBindingsContainer().addBinding(binding);
        } else {
            this.bindingsContainer.addBinding(binding);
        }
    }

    public void addBindings(Iterable<BindingDescription> bindings) {
        Iterator<BindingDescription> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            this.addBinding(iterator.next());
        }
    }

    public List<BindingDescription> getMergedBindings() {
        return this.bindingsContainer.getMergedBindings();
    }

    public void addAnnotationBindings(Collection<BindingDescription> bindings) {
        for (BindingDescription binding : bindings) {
            this.addAnnotationBinding(binding);
        }
    }

    private static <T> ProxyFactory<?> getProxyFactory(Class<T> type) {
        String proxyName = type.getName() + "$$ee$proxy" + seq.getAndIncrement();
        if (type.isInterface()) {
            return new ProxyFactory(proxyName, Object.class, type.getClassLoader(), new Class[]{type});
        }
        return new ProxyFactory(proxyName, type, type.getClassLoader(), new Class[0]);
    }

    public DeploymentDescriptorEnvironment getDeploymentDescriptorEnvironment() {
        return this.deploymentDescriptorEnvironment;
    }

    public void setDeploymentDescriptorEnvironment(DeploymentDescriptorEnvironment deploymentDescriptorEnvironment) {
        this.deploymentDescriptorEnvironment = deploymentDescriptorEnvironment;
    }

    public String toString() {
        return "AbstractComponentDescription{applicationName='" + this.applicationName + '\'' + ", moduleName='" + this.moduleName + '\'' + ", componentName='" + this.componentName + '\'' + '}';
    }
}

