/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.InjectionTargetDescription;

public class BindingDescription {
    private static final String JAVA = "java:";
    private BindingSourceDescription referenceSourceDescription;
    private boolean dependency;
    private final String bindingName;
    private String bindingType;
    private String description;
    private Resource.AuthenticationType authenticationType = Resource.AuthenticationType.CONTAINER;
    private boolean sharable = false;
    private List<InjectionTargetDescription> injectionTargetDescriptions = new ArrayList<InjectionTargetDescription>(1);

    public BindingDescription(String bindingName) {
        if (!bindingName.startsWith(JAVA)) {
            throw new RuntimeException("Absolute binding name " + bindingName + " must start with java:");
        }
        this.bindingName = bindingName;
    }

    public BindingDescription(String bindingName, AbstractComponentDescription componentDescription) {
        this.bindingName = !bindingName.startsWith(JAVA) ? (componentDescription.getNamingMode() == ComponentNamingMode.CREATE ? "java:comp/env/" + bindingName : "java:module/env/" + bindingName) : bindingName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<InjectionTargetDescription> getInjectionTargetDescriptions() {
        return this.injectionTargetDescriptions;
    }

    public boolean isDependency() {
        return this.dependency;
    }

    public void setDependency(boolean dependency) {
        this.dependency = dependency;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public String getBindingType() {
        return this.bindingType;
    }

    public void setBindingType(String bindingType) {
        this.bindingType = bindingType;
    }

    public BindingSourceDescription getReferenceSourceDescription() {
        return this.referenceSourceDescription;
    }

    public void setReferenceSourceDescription(BindingSourceDescription referenceSourceDescription) {
        if (referenceSourceDescription == null) {
            throw new IllegalArgumentException("referenceSourceDescription is null");
        }
        this.referenceSourceDescription = referenceSourceDescription;
    }

    public Resource.AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(Resource.AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public boolean isSharable() {
        return this.sharable;
    }

    public void setSharable(boolean sharable) {
        this.sharable = sharable;
    }

    public String toString() {
        return "BindingDescription{bindingName='" + this.bindingName + '\'' + ", bindingType='" + this.bindingType + '\'' + ", referenceSourceDescription=" + this.referenceSourceDescription + '}';
    }
}

