/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;

public class BindingsContainer {
    private final Map<String, BindingDescription> annotationBindingDescriptions = new HashMap<String, BindingDescription>();
    private final Map<String, BindingDescription> bindingDescriptions = new HashMap<String, BindingDescription>();
    private volatile List<BindingDescription> bindings;

    public synchronized void addAnnotationBinding(BindingDescription binding) {
        this.bindings = null;
        String bindingName = binding.getBindingName();
        if (this.bindingDescriptions.containsKey(bindingName)) {
            BindingDescription existingBinding = this.bindingDescriptions.get(bindingName);
            if (existingBinding.isSharable() != binding.isSharable() || existingBinding.getAuthenticationType() != binding.getAuthenticationType() || !existingBinding.getBindingType().equals(binding.getBindingType())) {
                throw new RuntimeException("Error merging binding " + binding + " with " + existingBinding + " in " + this + ", the JNDI bindings are not compatible.");
            }
            existingBinding.getInjectionTargetDescriptions().addAll(binding.getInjectionTargetDescriptions());
        } else {
            if (this.annotationBindingDescriptions.containsKey(bindingName)) {
                BindingDescription existingBinding;
                if (binding.getInjectionTargetDescriptions().size() == 1 && (existingBinding = this.annotationBindingDescriptions.get(bindingName)).getInjectionTargetDescriptions().size() == 1) {
                    InjectionTargetDescription existingTarget = existingBinding.getInjectionTargetDescriptions().get(0);
                    InjectionTargetDescription newTarget = binding.getInjectionTargetDescriptions().get(0);
                    if (newTarget.getClassName().equals(existingTarget.getClassName()) && newTarget.getType().equals((Object)existingTarget.getType()) && newTarget.getName().equals(existingTarget.getName())) {
                        return;
                    }
                }
                throw new RuntimeException("Duplicate binding of JNDI name " + bindingName);
            }
            this.annotationBindingDescriptions.put(bindingName, binding);
        }
    }

    public void addAnnotationBindings(Collection<BindingDescription> bindings) {
        for (BindingDescription binding : bindings) {
            this.addAnnotationBinding(binding);
        }
    }

    public synchronized void addBinding(BindingDescription binding) {
        this.bindings = null;
        String bindingName = binding.getBindingName();
        if (this.bindingDescriptions.containsKey(bindingName)) {
            throw new RuntimeException("JNDI binding for " + binding.getBindingName() + " has already been set " + binding);
        }
        if (this.annotationBindingDescriptions.containsKey(bindingName)) {
            BindingDescription existingBinding = this.annotationBindingDescriptions.get(bindingName);
            if (!existingBinding.getBindingType().equals(binding.getBindingType())) {
                throw new RuntimeException("Error overriding annotation based binding" + binding + " with " + existingBinding + ", the JNDI bindings are not compatible.");
            }
            binding.getInjectionTargetDescriptions().addAll(existingBinding.getInjectionTargetDescriptions());
            this.annotationBindingDescriptions.remove(bindingName);
        }
        this.bindingDescriptions.put(bindingName, binding);
    }

    public void addBindings(Collection<BindingDescription> bindings) throws DeploymentUnitProcessingException {
        for (BindingDescription binding : bindings) {
            this.addBinding(binding);
        }
    }

    public synchronized List<BindingDescription> getMergedBindings() {
        if (this.bindings == null) {
            ArrayList<BindingDescription> bindings = new ArrayList<BindingDescription>();
            HashSet<String> names = new HashSet<String>(this.annotationBindingDescriptions.keySet());
            names.addAll(this.bindingDescriptions.keySet());
            for (String name : names) {
                if (this.bindingDescriptions.containsKey(name)) {
                    bindings.add(this.bindingDescriptions.get(name));
                    continue;
                }
                bindings.add(this.annotationBindingDescriptions.get(name));
            }
            this.bindings = Collections.unmodifiableList(bindings);
        }
        return this.bindings;
    }
}

