/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponent;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentCreateService;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionFactory;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.JndiInjectionPointStore;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.ee.naming.NamespaceSelectorService;
import org.jboss.as.ee.naming.RootContextService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public final class ComponentInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (AbstractComponentDescription description : moduleDescription.getComponentDescriptions()) {
            try {
                this.deployComponent(phaseContext, description);
            }
            catch (RuntimeException e) {
                throw new DeploymentUnitProcessingException("Failed to install component " + description, (Throwable)e);
            }
        }
    }

    protected void deployComponent(DeploymentPhaseContext phaseContext, AbstractComponentDescription description) throws DeploymentUnitProcessingException {
        ServiceName componentContextServiceName;
        Class<?> componentClass;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        JndiInjectionPointStore moduleInjectionPointStore = (JndiInjectionPointStore)deploymentUnit.getAttachment(Attachments.MODULE_INJECTIONS);
        JndiInjectionPointStore injectionPointStore = moduleInjectionPointStore != null ? new JndiInjectionPointStore(moduleInjectionPointStore) : new JndiInjectionPointStore();
        String className = description.getComponentClassName();
        try {
            componentClass = Class.forName(className, false, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Component class not found", (Throwable)e);
        }
        String applicationName = description.getApplicationName();
        String moduleName = description.getModuleName();
        String componentName = description.getComponentName();
        ServiceName baseName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentName});
        AbstractComponentConfiguration configuration = description.createComponentConfiguration(phaseContext, componentClass);
        configuration.setComponentClass(componentClass);
        ArrayList<ServiceName> additionalDependencies = new ArrayList<ServiceName>();
        for (InjectionFactory injectionFactory : moduleDescription.getInjectionFactories()) {
            ComponentInjector injector = injectionFactory.createInjector(configuration);
            if (injector == null) continue;
            configuration.addComponentInjector(injector);
            ServiceName injectorServiceName = injector.getServiceName();
            if (injector.getServiceName() == null) continue;
            additionalDependencies.add(injectorServiceName);
        }
        ServiceName createServiceName = baseName.append(new String[]{"CREATE"});
        ServiceName startServiceName = baseName.append(new String[]{"START"});
        ComponentCreateService createService = new ComponentCreateService(configuration);
        ServiceBuilder createBuilder = serviceTarget.addService(createServiceName, (Service)createService);
        ComponentStartService startService = new ComponentStartService();
        ServiceBuilder startBuilder = serviceTarget.addService(startServiceName, (Service)startService);
        Map<ServiceName, InjectedValue<Object>> injections = configuration.getDependencyInjections();
        for (Map.Entry<ServiceName, ServiceBuilder.DependencyType> entry : description.getDependencies().entrySet()) {
            createBuilder.addDependency(entry.getValue(), entry.getKey(), (Injector)injections.get(entry.getKey()));
        }
        ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication(applicationName);
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule(applicationName, moduleName);
        switch (description.getNamingMode()) {
            case CREATE: {
                componentContextServiceName = ContextNames.contextServiceNameOfComponent(applicationName, moduleName, componentName);
                RootContextService contextService = new RootContextService();
                serviceTarget.addService(componentContextServiceName, (Service)contextService).addDependency(createServiceName).install();
                break;
            }
            case USE_MODULE: {
                componentContextServiceName = moduleContextServiceName;
                break;
            }
            default: {
                componentContextServiceName = null;
            }
        }
        NamespaceSelectorService selectorService = new NamespaceSelectorService();
        ServiceName selectorServiceName = baseName.append(new String[]{"NAMESPACE"});
        ServiceBuilder selectorServiceBuilder = serviceTarget.addService(selectorServiceName, (Service)selectorService).addDependency(appContextServiceName, NamingStore.class, selectorService.getApp()).addDependency(moduleContextServiceName, NamingStore.class, selectorService.getModule());
        if (componentContextServiceName != null) {
            selectorServiceBuilder.addDependency(componentContextServiceName, NamingStore.class, selectorService.getComp());
        }
        selectorServiceBuilder.install();
        startBuilder.addDependency(createServiceName, AbstractComponent.class, startService.getComponentInjector());
        startBuilder.addDependencies(additionalDependencies);
        for (Map.Entry<Class<?>, ProxyFactory<?>> entry : configuration.getProxyFactories().entrySet()) {
            Class<?> viewClass = entry.getKey();
            ServiceName serviceName = baseName.append(new String[]{"VIEW"}).append(new String[]{viewClass.getName()});
            ProxyFactory<?> proxyFactory = entry.getValue();
            ViewService viewService = new ViewService(viewClass, proxyFactory);
            serviceTarget.addService(serviceName, (Service)viewService).addDependency(createServiceName, AbstractComponent.class, viewService.getComponentInjector()).install();
            configuration.getViewServices().put(viewClass, serviceName);
        }
        List<BindingDescription> bindingDescriptions = description.getMergedBindings();
        for (BindingDescription bindingDescription : bindingDescriptions) {
            ComponentInstallProcessor.addJndiBinding(classLoader, serviceTarget, applicationName, moduleName, componentName, createServiceName, (ServiceBuilder<Component>)startBuilder, bindingDescription, phaseContext, injectionPointStore);
        }
        Collection<InterceptorDescription> interceptorClasses = description.getAllInterceptors().values();
        for (InterceptorDescription interceptorDescription : interceptorClasses) {
            Class<?> interceptorClass;
            String interceptorClassName = interceptorDescription.getInterceptorClassName();
            try {
                interceptorClass = Class.forName(interceptorClassName, false, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException("Component interceptor class not found", (Throwable)e);
            }
            List<ResourceInjection> injectionList = injectionPointStore.applyInjections(interceptorClass, deploymentReflectionIndex);
            configuration.addInterceptorResourceInjection(interceptorClass, injectionList);
        }
        List<ResourceInjection> injectionList = injectionPointStore.applyInjections(componentClass, deploymentReflectionIndex);
        startBuilder.addDependencies(injectionPointStore.getServiceNames());
        configuration.getResourceInjections().addAll(injectionList);
        createBuilder.install();
        startBuilder.install();
    }

    private static void addJndiBinding(ModuleClassLoader classLoader, ServiceTarget serviceTarget, String applicationName, String moduleName, String componentName, ServiceName createServiceName, ServiceBuilder<Component> startBuilder, BindingDescription bindingDescription, DeploymentPhaseContext phaseContext, JndiInjectionPointStore injectionPointStore) throws DeploymentUnitProcessingException {
        String bindingName = bindingDescription.getBindingName();
        String bindingType = bindingDescription.getBindingType();
        try {
            Class.forName(bindingType, false, (ClassLoader)classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Component binding class not found", (Throwable)e);
        }
        if (bindingName != null) {
            int idx = bindingName.indexOf(47);
            String serviceBindingName = idx == -1 ? bindingName : bindingName.substring(idx + 1);
            BinderService service = new BinderService(serviceBindingName);
            ServiceName bindingServiceName = ContextNames.serviceNameOfContext(applicationName, moduleName, componentName, bindingName);
            if (bindingServiceName == null) {
                throw new IllegalArgumentException("Invalid context name '" + bindingName + "' for binding");
            }
            ServiceBuilder sourceServiceBuilder = serviceTarget.addService(bindingServiceName, (Service)service);
            bindingDescription.getReferenceSourceDescription().getResourceValue(bindingDescription, sourceServiceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            ServiceController resourceValue = sourceServiceBuilder.addDependency(createServiceName).addDependency(bindingServiceName.getParent(), NamingStore.class, service.getNamingStoreInjector()).install();
            if (bindingDescription.isDependency()) {
                startBuilder.addDependency(bindingServiceName);
            }
            for (InjectionTargetDescription injectionTarget : bindingDescription.getInjectionTargetDescriptions()) {
                injectionPointStore.addInjectedValue(injectionTarget, (Value<ManagedReferenceFactory>)resourceValue, bindingServiceName);
            }
        } else {
            InjectedValue injectedValue = new InjectedValue();
            bindingDescription.getReferenceSourceDescription().getResourceValue(bindingDescription, startBuilder, phaseContext, (Injector<ManagedReferenceFactory>)injectedValue);
            InjectedValue resourceValue = injectedValue;
            for (InjectionTargetDescription injectionTarget : bindingDescription.getInjectionTargetDescriptions()) {
                injectionPointStore.addInjectedValue(injectionTarget, (Value<ManagedReferenceFactory>)resourceValue, null);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

