/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.JndiInjectionPointStore;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

public class ModuleJndiBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        JndiInjectionPointStore moduleInjectionPointStore = new JndiInjectionPointStore();
        deploymentUnit.putAttachment(Attachments.MODULE_INJECTIONS, (Object)moduleInjectionPointStore);
        for (BindingDescription binding : moduleDescription.getBindingsContainer().getMergedBindings()) {
            this.addJndiBinding(moduleDescription, moduleDescription.getModuleName(), binding, phaseContext, moduleInjectionPointStore);
        }
    }

    protected void addJndiBinding(EEModuleDescription module, String componentName, BindingDescription bindingDescription, DeploymentPhaseContext phaseContext, JndiInjectionPointStore injectionPointStore) throws DeploymentUnitProcessingException {
        String bindingName = bindingDescription.getBindingName();
        String bindingType = bindingDescription.getBindingType();
        if (bindingName != null) {
            int idx = bindingName.indexOf(47);
            String serviceBindingName = idx == -1 ? bindingName : bindingName.substring(idx + 1);
            BinderService service = new BinderService(serviceBindingName);
            ServiceName bindingServiceName = ContextNames.serviceNameOfContext(module.getAppName(), module.getModuleName(), componentName, bindingName);
            if (bindingServiceName == null) {
                throw new IllegalArgumentException("Invalid context name '" + bindingName + "' for binding");
            }
            ServiceBuilder sourceServiceBuilder = phaseContext.getServiceTarget().addService(bindingServiceName, (Service)service);
            bindingDescription.getReferenceSourceDescription().getResourceValue(bindingDescription, sourceServiceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            ServiceController resourceValue = sourceServiceBuilder.addDependency(bindingServiceName.getParent(), NamingStore.class, service.getNamingStoreInjector()).install();
            for (InjectionTargetDescription injectionTarget : bindingDescription.getInjectionTargetDescriptions()) {
                injectionPointStore.addInjectedValue(injectionTarget, (Value<ManagedReferenceFactory>)resourceValue, bindingServiceName);
            }
        } else {
            throw new DeploymentUnitProcessingException("Binding name must not be null: " + bindingDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

