/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public final class EEModuleConfiguration {
    private final String applicationName;
    private final String moduleName;
    private final List<ComponentConfiguration> componentConfigurations;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();

    EEModuleConfiguration(EEModuleDescription description, DeploymentPhaseContext context, Module module) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        ModuleClassLoader classLoader = module.getClassLoader();
        this.applicationName = description.getApplicationName();
        this.moduleName = description.getModuleName();
        for (EEModuleConfigurator configurator : description.getConfigurators()) {
            configurator.configure(context, description, this);
        }
        this.componentConfigurations = new ArrayList<ComponentConfiguration>();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public Collection<ComponentConfiguration> getComponentConfigurations() {
        return Collections.unmodifiableList(this.componentConfigurations);
    }

    public void addComponentConfiguration(ComponentConfiguration configuration) {
        this.componentConfigurations.add(configuration);
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }
}

