/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.naming.RootContextService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.service.BindingHandleService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class ComponentInstallProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(ComponentInstallProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        EEModuleConfiguration moduleDescription = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        Set dependencies = (Set)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        ServiceName bindingDependencyService = JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit);
        for (ComponentConfiguration configuration : moduleDescription.getComponentConfigurations()) {
            try {
                logger.tracef("Installing component %s", (Object)configuration.getComponentClass().getName());
                this.deployComponent(phaseContext, configuration, dependencies, bindingDependencyService);
            }
            catch (RuntimeException e) {
                throw new DeploymentUnitProcessingException("Failed to install component " + configuration, (Throwable)e);
            }
        }
    }

    protected void deployComponent(final DeploymentPhaseContext phaseContext, final ComponentConfiguration configuration, final Set<ServiceName> dependencies, ServiceName bindingDependencyService) throws DeploymentUnitProcessingException {
        ServiceName contextServiceName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final ServiceVerificationHandler serviceVerificationHandler = (ServiceVerificationHandler)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.SERVICE_VERIFICATION_HANDLER);
        final ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String componentName = configuration.getComponentName();
        final ServiceName baseName = configuration.getComponentDescription().getServiceName();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ServiceName createServiceName = baseName.append(new String[]{"CREATE"});
        ServiceName startServiceName = baseName.append(new String[]{"START"});
        BasicComponentCreateService createService = configuration.getComponentCreateServiceFactory().constructService(configuration);
        ServiceBuilder createBuilder = serviceTarget.addService(createServiceName, (Service)createService);
        createBuilder.addDependency(deploymentUnit.getServiceName(), DeploymentUnit.class, createService.getDeploymentUnitInjector());
        ComponentStartService startService = new ComponentStartService();
        ServiceBuilder startBuilder = serviceTarget.addService(startServiceName, (Service)startService);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        final IntHolder i = new IntHolder();
        if (moduleConfiguration == null) {
            return;
        }
        for (DependencyConfigurator configurator : configuration.getCreateDependencies()) {
            configurator.configureDependency(createBuilder);
        }
        for (DependencyConfigurator configurator : configuration.getStartDependencies()) {
            configurator.configureDependency(startBuilder);
        }
        startBuilder.addDependency(createServiceName, BasicComponent.class, startService.getComponentInjector());
        startBuilder.addDependency(bindingDependencyService);
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            RootContextService contextService = new RootContextService();
            contextServiceName = ContextNames.contextServiceNameOfComponent((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName());
            serviceTarget.addService(contextServiceName, (Service)contextService).install();
        } else {
            contextServiceName = ContextNames.contextServiceNameOfModule((String)configuration.getApplicationName(), (String)configuration.getModuleName());
        }
        final InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, configuration.getComponentName(), configuration.getModuleName(), configuration.getApplicationName());
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            ServiceName serviceName = viewConfiguration.getViewServiceName();
            ViewService viewService = new ViewService(viewConfiguration);
            serviceTarget.addService(serviceName, (Service)viewService).addDependency(createServiceName, Component.class, viewService.getComponentInjector()).install();
            for (BindingConfiguration bindingConfiguration : viewConfiguration.getBindingConfigurations()) {
                String bindingName = bindingConfiguration.getName();
                ServiceName binderServiceName = ContextNames.serviceNameOfContext((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName);
                ServiceName namingStoreName = ContextNames.serviceNameOfNamingStore((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName);
                BindingHandleService service = new BindingHandleService(bindingName, binderServiceName, (Object)bindingConfiguration.getSource(), namingStoreName, serviceVerificationHandler);
                ServiceName handleServiceName = binderServiceName.append(baseName).append(new String[]{String.valueOf(i.value++)});
                dependencies.add(binderServiceName);
                ServiceBuilder serviceBuilder = serviceTarget.addService(handleServiceName, (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.install();
            }
        }
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, baseName, resolutionContext, configuration.getComponentDescription().getBindingConfigurations(), i, dependencies, serviceVerificationHandler);
            new ClassDescriptionTraversal(configuration.getModuleClassConfiguration(), applicationDescription){

                @Override
                protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, baseName, resolutionContext, classConfiguration.getBindingConfigurations(), i, dependencies, serviceVerificationHandler);
                }
            }.run();
            for (InterceptorDescription interceptor : configuration.getComponentDescription().getAllInterceptors()) {
                EEModuleClassConfiguration interceptorClass = applicationDescription.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                new ClassDescriptionTraversal(interceptorClass, applicationDescription){

                    @Override
                    protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, baseName, resolutionContext, classConfiguration.getBindingConfigurations(), i, dependencies, serviceVerificationHandler);
                    }
                }.run();
            }
        }
        createBuilder.install();
        startBuilder.install();
    }

    private void processBindings(DeploymentPhaseContext phaseContext, ComponentConfiguration configuration, ServiceTarget serviceTarget, ServiceName contextServiceName, ServiceName compServiceName, InjectionSource.ResolutionContext resolutionContext, List<BindingConfiguration> bindings, IntHolder handleCount, Set<ServiceName> dependencies, ServiceVerificationHandler serviceVerificationHandler) throws DeploymentUnitProcessingException {
        for (BindingConfiguration bindingConfiguration : bindings) {
            if (!bindingConfiguration.getName().startsWith("java:comp") && bindingConfiguration.getName().startsWith("java:")) continue;
            String bindingName = bindingConfiguration.getName().startsWith("java:comp") ? bindingConfiguration.getName() : "java:comp/env/" + bindingConfiguration.getName();
            ServiceName binderServiceName = ContextNames.serviceNameOfEnvEntry((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName(), (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE ? 1 : 0) != 0, (String)bindingName);
            BindingHandleService service = new BindingHandleService(bindingName, binderServiceName, (Object)bindingConfiguration.getSource(), contextServiceName, serviceVerificationHandler);
            ServiceName handleServiceName = binderServiceName.append(compServiceName).append(new String[]{String.valueOf(handleCount.value++)});
            dependencies.add(binderServiceName);
            ServiceBuilder serviceBuilder = serviceTarget.addService(handleServiceName, (Service)service);
            bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            serviceBuilder.install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static class IntHolder {
        private int value;

        private IntHolder() {
        }
    }
}

