/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ee.component.ViewBindingInjectionSource;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public class ViewDescription {
    private final String viewClassName;
    private final ComponentDescription componentDescription;
    private final List<String> viewNameParts = new ArrayList<String>();
    private final Set<String> bindingNames = new HashSet<String>();
    private final Deque<ViewConfigurator> configurators = new ArrayDeque<ViewConfigurator>();
    static final ImmediateInterceptorFactory CLIENT_DISPATCHER_INTERCEPTOR_FACTORY = new ImmediateInterceptorFactory(new Interceptor(){

        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentViewInstance viewInstance = (ComponentViewInstance)context.getPrivateData(ComponentViewInstance.class);
            return viewInstance.getEntryPoint(context.getMethod()).processInvocation(context);
        }
    });

    public ViewDescription(ComponentDescription componentDescription, String viewClassName) {
        this.componentDescription = componentDescription;
        this.viewClassName = viewClassName;
        this.configurators.addFirst(new DefaultConfigurator());
    }

    public String getViewClassName() {
        return this.viewClassName;
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public List<String> getViewNameParts() {
        return this.viewNameParts;
    }

    public ServiceName getServiceName() {
        if (!this.viewNameParts.isEmpty()) {
            return this.componentDescription.getServiceName().append(new String[]{"VIEW"}).append(this.viewNameParts.toArray(new String[this.viewNameParts.size()]));
        }
        return this.componentDescription.getServiceName().append(new String[]{"VIEW"}).append(new String[]{this.viewClassName});
    }

    public ViewConfiguration createViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ProxyFactory<?> proxyFactory) {
        return new ViewConfiguration(viewClass, componentConfiguration, this.getServiceName(), proxyFactory);
    }

    public Set<String> getBindingNames() {
        return this.bindingNames;
    }

    public Deque<ViewConfigurator> getConfigurators() {
        return this.configurators;
    }

    private static class ComponentDispatcherInterceptor
    implements Interceptor {
        private final Method componentMethod;

        public ComponentDispatcherInterceptor(Method componentMethod) {
            this.componentMethod = componentMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            ComponentInstance componentInstance = (ComponentInstance)context.getPrivateData(ComponentInstance.class);
            if (componentInstance == null) {
                throw new IllegalStateException("No component instance associated");
            }
            Method oldMethod = context.getMethod();
            try {
                context.setMethod(this.componentMethod);
                context.setTarget(componentInstance.getInstance());
                Object object = componentInstance.getInterceptor(this.componentMethod).processInvocation(context);
                return object;
            }
            finally {
                context.setMethod(oldMethod);
                context.setTarget(null);
            }
        }
    }

    private static class DefaultConfigurator
    implements ViewConfigurator {
        private DefaultConfigurator() {
        }

        @Override
        public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
            Method[] methods;
            DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
            ClassReflectionIndex index = reflectionIndex.getClassIndex(componentConfiguration.getComponentClass());
            for (Method method : methods = configuration.getProxyFactory().getCachedMethods()) {
                Method componentMethod = ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)reflectionIndex, (ClassReflectionIndex)index, (Method)method);
                configuration.addViewInterceptor(method, (InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ComponentDispatcherInterceptor(componentMethod)), 2048);
                configuration.addClientInterceptor(method, (InterceptorFactory)CLIENT_DISPATCHER_INTERCEPTOR_FACTORY, 512);
            }
            configuration.addViewPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
            configuration.addViewPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 512);
            configuration.addClientPostConstructInterceptor(Interceptors.getTerminalInterceptorFactory(), 256);
            configuration.addClientPreDestroyInterceptor(Interceptors.getTerminalInterceptorFactory(), 256);
            List<BindingConfiguration> bindingConfigurations = configuration.getBindingConfigurations();
            List<String> viewNameParts = description.getViewNameParts();
            ServiceName serviceName = !viewNameParts.isEmpty() ? context.getDeploymentUnit().getServiceName().append(new String[]{"component"}).append(new String[]{componentConfiguration.getComponentName()}).append(new String[]{"VIEW"}).append(viewNameParts.toArray(new String[viewNameParts.size()])) : context.getDeploymentUnit().getServiceName().append(new String[]{"component"}).append(new String[]{componentConfiguration.getComponentName()}).append(new String[]{"VIEW"}).append(new String[]{description.getViewClassName()});
            for (String bindingName : description.getBindingNames()) {
                bindingConfigurations.add(new BindingConfiguration(bindingName, new ViewBindingInjectionSource(serviceName)));
            }
        }
    }
}

