/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;

public final class InjectedEENamespaceContextSelector
extends NamespaceContextSelector {
    private static final CompositeName EMPTY_NAME = new CompositeName();
    private final InjectedValue<NamingStore> appContext = new InjectedValue();
    private final InjectedValue<NamingStore> moduleContext = new InjectedValue();
    private final InjectedValue<NamingStore> compContext = new InjectedValue();

    public Injector<NamingStore> getAppContextInjector() {
        return this.appContext;
    }

    public Injector<NamingStore> getModuleContextInjector() {
        return this.moduleContext;
    }

    public Injector<NamingStore> getCompContextInjector() {
        return this.compContext;
    }

    private NamingStore getNamingStore(String identifier) {
        if (identifier.equals("app")) {
            return (NamingStore)this.appContext.getOptionalValue();
        }
        if (identifier.equals("module")) {
            return (NamingStore)this.moduleContext.getOptionalValue();
        }
        if (identifier.equals("comp")) {
            return (NamingStore)this.compContext.getOptionalValue();
        }
        return null;
    }

    public Context getContext(String identifier) {
        NamingStore namingStore = this.getNamingStore(identifier);
        if (namingStore != null) {
            try {
                return (Context)namingStore.lookup((Name)EMPTY_NAME);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

