/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public final class EEModuleClassConfiguration {
    private final EEModuleClassDescription moduleClassDescription;
    private final Class<?> moduleClass;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final List<ResourceInjectionConfiguration> injectionConfigurations = new ArrayList<ResourceInjectionConfiguration>();
    private final Map<ServiceName, InjectedValue<Object>> dependencyInjections = new HashMap<ServiceName, InjectedValue<Object>>();
    private ManagedReferenceFactory instantiator;
    private final DeploymentReflectionIndex deploymentReflectionIndex;
    private volatile Set<Method> classMethods;

    public EEModuleClassConfiguration(Class<?> moduleClass, EEModuleClassDescription moduleClassDescription, DeploymentReflectionIndex deploymentReflectionIndex) {
        this.moduleClass = moduleClass;
        this.moduleClassDescription = moduleClassDescription;
        this.deploymentReflectionIndex = deploymentReflectionIndex;
    }

    public Class<?> getModuleClass() {
        return this.moduleClass;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public List<ResourceInjectionConfiguration> getInjectionConfigurations() {
        return this.injectionConfigurations;
    }

    public Map<ServiceName, InjectedValue<Object>> getDependencyInjections() {
        return this.dependencyInjections;
    }

    public ManagedReferenceFactory getInstantiator() {
        return this.instantiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getClassMethods() {
        if (this.classMethods == null) {
            EEModuleClassConfiguration eEModuleClassConfiguration = this;
            synchronized (eEModuleClassConfiguration) {
                if (this.classMethods == null) {
                    Set methods = Collections.newSetFromMap(new IdentityHashMap());
                    for (Class<?> clazz = this.moduleClass; clazz != null; clazz = clazz.getSuperclass()) {
                        methods.addAll(this.deploymentReflectionIndex.getClassIndex(clazz).getMethods());
                    }
                    this.classMethods = methods;
                }
            }
        }
        return this.classMethods;
    }

    public void setInstantiator(ManagedReferenceFactory instantiator) {
        this.instantiator = instantiator;
    }

    public EEModuleClassDescription getModuleClassDescription() {
        return this.moduleClassDescription;
    }
}

