/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class LookupInjectionSource
extends InjectionSource {
    private final String lookupName;

    public LookupInjectionSource(String lookupName) {
        if (lookupName == null) {
            throw new IllegalArgumentException("lookupName is null");
        }
        this.lookupName = lookupName;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        String applicationName = resolutionContext.getApplicationName();
        String moduleName = resolutionContext.getModuleName();
        String componentName = resolutionContext.getComponentName();
        boolean compUsesModule = resolutionContext.isCompUsesModule();
        String lookupName = !this.lookupName.startsWith("java:") ? (componentName != null && !compUsesModule ? "java:comp/env/" + this.lookupName : (compUsesModule ? "java:module/env/" + this.lookupName : "java:jboss/env" + this.lookupName)) : (this.lookupName.startsWith("java:comp/") && compUsesModule ? "java:module/" + this.lookupName.substring(10) : this.lookupName);
        ServiceName serviceName = ContextNames.serviceNameOfContext((String)applicationName, (String)moduleName, (String)componentName, (String)lookupName);
        serviceBuilder.addDependency(serviceName, ManagedReferenceFactory.class, injector);
    }

    public boolean equals(Object configuration) {
        if (configuration instanceof LookupInjectionSource) {
            LookupInjectionSource lookup = (LookupInjectionSource)configuration;
            return this.lookupName.equals(lookup.lookupName);
        }
        return false;
    }

    public int hashCode() {
        return this.lookupName.hashCode();
    }
}

