/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentCreateServiceFactory;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.interceptors.OrderedItemContainer;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.service.Service;

public class ComponentConfiguration {
    private final ComponentDescription componentDescription;
    private final EEModuleClassConfiguration moduleClassConfiguration;
    private ComponentCreateServiceFactory componentCreateServiceFactory = ComponentCreateServiceFactory.BASIC;
    private final OrderedItemContainer<InterceptorFactory> postConstructInterceptors = new OrderedItemContainer();
    private final OrderedItemContainer<InterceptorFactory> preDestroyInterceptors = new OrderedItemContainer();
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> componentInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> timeoutInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private ManagedReferenceFactory instanceFactory;
    private final List<DependencyConfigurator<? extends Service<Component>>> createDependencies = new ArrayList<DependencyConfigurator<? extends Service<Component>>>();
    private final List<DependencyConfigurator<ComponentStartService>> startDependencies = new ArrayList<DependencyConfigurator<ComponentStartService>>();
    private final List<ViewConfiguration> views = new ArrayList<ViewConfiguration>();
    private InterceptorFactory namespaceContextInterceptorFactory;

    public ComponentConfiguration(ComponentDescription componentDescription, EEModuleClassConfiguration moduleClassConfiguration) {
        this.componentDescription = componentDescription;
        this.moduleClassConfiguration = moduleClassConfiguration;
    }

    public ComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    public Class<?> getComponentClass() {
        return this.moduleClassConfiguration.getModuleClass();
    }

    public String getComponentName() {
        return this.componentDescription.getComponentName();
    }

    public Set<Method> getDefinedComponentMethods() {
        return this.moduleClassConfiguration.getClassMethods();
    }

    public List<InterceptorFactory> getComponentInterceptors(Method method) {
        Map<Method, OrderedItemContainer<InterceptorFactory>> map = this.componentInterceptors;
        OrderedItemContainer<InterceptorFactory> interceptors = map.get(method);
        if (interceptors == null) {
            return Collections.emptyList();
        }
        return interceptors.getSortedItems();
    }

    public List<InterceptorFactory> getAroundTimeoutInterceptors(Method method) {
        Map<Method, OrderedItemContainer<InterceptorFactory>> map = this.timeoutInterceptors;
        OrderedItemContainer<InterceptorFactory> interceptors = map.get(method);
        if (interceptors == null) {
            return Collections.emptyList();
        }
        return interceptors.getSortedItems();
    }

    public void addComponentInterceptor(InterceptorFactory factory, int priority, boolean publicOnly) {
        for (Method method : this.moduleClassConfiguration.getClassMethods()) {
            if (publicOnly && !Modifier.isPublic(method.getModifiers())) continue;
            OrderedItemContainer<Object> interceptors = this.componentInterceptors.get(method);
            if (interceptors == null) {
                interceptors = new OrderedItemContainer();
                this.componentInterceptors.put(method, interceptors);
            }
            interceptors.add(factory, priority);
        }
    }

    public void addComponentInterceptor(Method method, InterceptorFactory factory, int priority) {
        OrderedItemContainer<Object> interceptors = this.componentInterceptors.get(method);
        if (interceptors == null) {
            interceptors = new OrderedItemContainer();
            this.componentInterceptors.put(method, interceptors);
        }
        interceptors.add(factory, priority);
    }

    public void addTimeoutInterceptor(Method method, InterceptorFactory factory, int priority) {
        OrderedItemContainer<Object> interceptors = this.timeoutInterceptors.get(method);
        if (interceptors == null) {
            interceptors = new OrderedItemContainer();
            this.timeoutInterceptors.put(method, interceptors);
        }
        interceptors.add(factory, priority);
    }

    public void addTimeoutInterceptor(InterceptorFactory factory, int priority) {
        for (Method method : this.moduleClassConfiguration.getClassMethods()) {
            OrderedItemContainer<Object> interceptors = this.timeoutInterceptors.get(method);
            if (interceptors == null) {
                interceptors = new OrderedItemContainer();
                this.timeoutInterceptors.put(method, interceptors);
            }
            interceptors.add(factory, priority);
        }
    }

    public List<DependencyConfigurator<? extends Service<Component>>> getCreateDependencies() {
        return this.createDependencies;
    }

    public List<DependencyConfigurator<ComponentStartService>> getStartDependencies() {
        return this.startDependencies;
    }

    public List<ViewConfiguration> getViews() {
        return this.views;
    }

    public List<InterceptorFactory> getPostConstructInterceptors() {
        return this.postConstructInterceptors.getSortedItems();
    }

    public void addPostConstructInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.postConstructInterceptors.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getPreDestroyInterceptors() {
        return this.preDestroyInterceptors.getSortedItems();
    }

    public void addPreDestroyInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.preDestroyInterceptors.add(interceptorFactory, priority);
    }

    public String getApplicationName() {
        return this.componentDescription.getApplicationName();
    }

    public String getModuleName() {
        return this.componentDescription.getModuleName();
    }

    public ManagedReferenceFactory getInstanceFactory() {
        return this.instanceFactory;
    }

    public void setInstanceFactory(ManagedReferenceFactory instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public EEModuleClassConfiguration getModuleClassConfiguration() {
        return this.moduleClassConfiguration;
    }

    public ComponentCreateServiceFactory getComponentCreateServiceFactory() {
        return this.componentCreateServiceFactory;
    }

    public void setComponentCreateServiceFactory(ComponentCreateServiceFactory componentCreateServiceFactory) {
        if (componentCreateServiceFactory == null) {
            throw new IllegalArgumentException("componentCreateServiceFactory is null");
        }
        this.componentCreateServiceFactory = componentCreateServiceFactory;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.componentDescription.getComponentName() + " class=" + this.componentDescription.getComponentClassName() + "]";
    }

    public InterceptorFactory getNamespaceContextInterceptorFactory() {
        return this.namespaceContextInterceptorFactory;
    }

    public void setNamespaceContextInterceptorFactory(InterceptorFactory interceptorFactory) {
        this.namespaceContextInterceptorFactory = interceptorFactory;
    }
}

