/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class ComponentInstallProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(ComponentInstallProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        EEModuleConfiguration moduleDescription = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        Set dependencies = (Set)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.JNDI_DEPENDENCIES);
        ServiceName bindingDependencyService = JndiNamingDependencyProcessor.serviceName((DeploymentUnit)deploymentUnit);
        for (ComponentConfiguration configuration : moduleDescription.getComponentConfigurations()) {
            try {
                logger.tracef("Installing component %s", (Object)configuration.getComponentClass().getName());
                this.deployComponent(phaseContext, configuration, dependencies, bindingDependencyService);
            }
            catch (RuntimeException e) {
                throw new DeploymentUnitProcessingException("Failed to install component " + configuration, (Throwable)e);
            }
        }
    }

    protected void deployComponent(final DeploymentPhaseContext phaseContext, final ComponentConfiguration configuration, final Set<ServiceName> dependencies, ServiceName bindingDependencyService) throws DeploymentUnitProcessingException {
        ServiceName contextServiceName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String componentName = configuration.getComponentName();
        ServiceName baseName = configuration.getComponentDescription().getServiceName();
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        ServiceName createServiceName = configuration.getComponentDescription().getCreateServiceName();
        ServiceName startServiceName = configuration.getComponentDescription().getStartServiceName();
        BasicComponentCreateService createService = configuration.getComponentCreateServiceFactory().constructService(configuration);
        ServiceBuilder createBuilder = serviceTarget.addService(createServiceName, (Service)createService);
        createBuilder.addDependency(deploymentUnit.getServiceName(), DeploymentUnit.class, createService.getDeploymentUnitInjector());
        ComponentStartService startService = new ComponentStartService();
        ServiceBuilder startBuilder = serviceTarget.addService(startServiceName, (Service)startService);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        for (DependencyConfigurator<? extends Service<Component>> dependencyConfigurator : configuration.getCreateDependencies()) {
            dependencyConfigurator.configureDependency(createBuilder, createService);
        }
        for (DependencyConfigurator<Object> dependencyConfigurator : configuration.getStartDependencies()) {
            dependencyConfigurator.configureDependency(startBuilder, startService);
        }
        startBuilder.addDependency(createServiceName, BasicComponent.class, startService.getComponentInjector());
        startBuilder.addDependency(bindingDependencyService);
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            NamingStoreService namingStoreService = new NamingStoreService();
            contextServiceName = ContextNames.contextServiceNameOfComponent((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName());
            serviceTarget.addService(contextServiceName, (Service)namingStoreService).install();
        } else {
            contextServiceName = ContextNames.contextServiceNameOfModule((String)configuration.getApplicationName(), (String)configuration.getModuleName());
        }
        final InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, configuration.getComponentName(), configuration.getModuleName(), configuration.getApplicationName());
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            ServiceName serviceName = viewConfiguration.getViewServiceName();
            ViewService viewService = new ViewService(viewConfiguration);
            serviceTarget.addService(serviceName, (Service)viewService).addDependency(createServiceName, Component.class, viewService.getComponentInjector()).install();
            for (BindingConfiguration bindingConfiguration : viewConfiguration.getBindingConfigurations()) {
                String bindingName = bindingConfiguration.getName();
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName);
                BinderService service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                dependencies.add(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service.getNamingStoreInjector());
                serviceBuilder.install();
            }
        }
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, configuration.getComponentDescription().getBindingConfigurations(), dependencies);
            new ClassDescriptionTraversal(configuration.getModuleClassConfiguration(), applicationDescription){

                @Override
                protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, classConfiguration.getBindingConfigurations(), dependencies);
                }
            }.run();
            for (InterceptorDescription interceptor : configuration.getComponentDescription().getAllInterceptors()) {
                EEModuleClassConfiguration interceptorClass = applicationDescription.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                new ClassDescriptionTraversal(interceptorClass, applicationDescription){

                    @Override
                    protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, classConfiguration.getBindingConfigurations(), dependencies);
                    }
                }.run();
            }
        }
        createBuilder.install();
        startBuilder.install();
    }

    private void processBindings(DeploymentPhaseContext phaseContext, ComponentConfiguration configuration, ServiceTarget serviceTarget, ServiceName contextServiceName, InjectionSource.ResolutionContext resolutionContext, List<BindingConfiguration> bindings, Set<ServiceName> dependencies) throws DeploymentUnitProcessingException {
        for (BindingConfiguration bindingConfiguration : bindings) {
            if (!bindingConfiguration.getName().startsWith("java:comp") && bindingConfiguration.getName().startsWith("java:")) continue;
            String bindingName = bindingConfiguration.getName().startsWith("java:comp") ? bindingConfiguration.getName() : "java:comp/env/" + bindingConfiguration.getName();
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName(), (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE ? 1 : 0) != 0, (String)bindingName);
            try {
                BinderService service = new BinderService(bindInfo.getBindName(), (Object)bindingConfiguration.getSource());
                dependencies.add(bindInfo.getBinderServiceName());
                ServiceBuilder serviceBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, service.getNamingStoreInjector());
                serviceBuilder.install();
            }
            catch (DuplicateServiceException e) {
                ServiceController registered = CurrentServiceContainer.getServiceContainer().getService(bindInfo.getBinderServiceName());
                if (registered == null) {
                    throw e;
                }
                BinderService service = (BinderService)registered.getService();
                if (service.getSource().equals(bindingConfiguration.getSource())) continue;
                throw new IllegalArgumentException("Incompatible conflicting binding at " + bindingName + " source: " + bindingConfiguration.getSource());
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

