/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee;

import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="JBAS")
public interface EeLogger
extends BasicLogger {
    public static final EeLogger ROOT_LOGGER = (EeLogger)Logger.getMessageLogger(EeLogger.class, (String)EeLogger.class.getPackage().getName());
    public static final EeLogger SERVER_DEPLOYMENT_LOGGER = (EeLogger)Logger.getMessageLogger(EeLogger.class, (String)"org.jboss.as.server.deployment");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11000, value="Transactional datasource %s could not be proxied and will not be enlisted in transactions automatically")
    public void cannotProxyTransactionalDatasource(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11001, value="Could not resolve %s %s")
    public void cannotResolve(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11002, value="Class Path entry %s in %s does not point to a valid jar for a Class-Path reference.")
    public void classPathEntryNotAJar(String var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11003, value="Class Path entry in %s may not point to a sub deployment.")
    public void classPathEntryNotASubDeployment(VirtualFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11004, value="Class Path entry %s in %s not found.")
    public void classPathEntryNotFound(String var1, VirtualFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11005, value="Failed to destroy component instance %s")
    public void componentDestroyFailure(@Cause Throwable var1, ComponentInstance var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11006, value="Not installing optional component %s due to exception")
    public void componentInstallationFailure(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11007, value="Ignoring property %s due to missing setter method: %s(%s) on datasource class: %s")
    public void ignoringProperty(String var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11008, value="[Managed Bean spec, section %s] Managed bean implementation class MUST NOT be an interface - %s is an interface, hence won't be considered as a managed bean.")
    public void invalidManagedBeanAbstractOrFinal(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11009, value="[Managed Bean spec, section %s] Managed bean implementation class MUST NOT be abstract or final - %s won't be considered as a managed bean, since it doesn't meet that requirement.")
    public void invalidManagedBeanInterface(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11010, value="Exception while invoking pre-destroy interceptor for component class: %s")
    public void preDestroyInterceptorFailure(@Cause Throwable var1, Class<?> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11011, value="Transactional datasource %s will not be enlisted in the transaction as the transaction subsystem is not available")
    public void transactionSubsystemNotAvailable(String var1);
}

