/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;

public class EEResourceReferenceProcessorRegistry {
    private final Map<String, EEResourceReferenceProcessor> resourceReferenceProcessors = new ConcurrentHashMap<String, EEResourceReferenceProcessor>();

    public void registerResourceReferenceProcessor(EEResourceReferenceProcessor resourceReferenceProcessor) {
        if (resourceReferenceProcessor == null) {
            throw EeMessages.MESSAGES.nullResourceReference();
        }
        String resourceReferenceType = resourceReferenceProcessor.getResourceReferenceType();
        if (resourceReferenceType == null || resourceReferenceType.trim().isEmpty()) {
            throw EeMessages.MESSAGES.nullOrEmptyResourceReferenceType();
        }
        this.resourceReferenceProcessors.put(resourceReferenceType, resourceReferenceProcessor);
    }

    public EEResourceReferenceProcessor getResourceReferenceProcessor(String resourceReferenceType) {
        return this.resourceReferenceProcessors.get(resourceReferenceType);
    }
}

