/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public final class ProxyInvocationHandler
implements InvocationHandler {
    private final Map<Method, Interceptor> interceptors;
    private final Component component;
    private final ComponentView componentView;

    public ProxyInvocationHandler(Map<Method, Interceptor> interceptors, Component component, ComponentView componentView) {
        this.interceptors = interceptors;
        this.component = component;
        this.componentView = componentView;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Interceptor interceptor = this.interceptors.get(method);
        if (interceptor == null) {
            throw new NoSuchMethodError(method.toString());
        }
        InterceptorContext context = new InterceptorContext();
        context.putPrivateData(Object.class, proxy);
        context.putPrivateData(Component.class, (Object)this.component);
        context.putPrivateData(ComponentView.class, (Object)this.componentView);
        context.setParameters(args);
        context.setMethod(method);
        context.setContextData(new HashMap());
        return interceptor.processInvocation(context);
    }
}

