/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.jboss.as.ejb3.component.CancellationFlag;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.threads.AsyncFutureTask;

public final class AsyncFutureInterceptor
implements Interceptor {
    private final Executor executor;

    public AsyncFutureInterceptor(Executor executor) {
        this.executor = executor;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        InterceptorContext asyncInterceptorContext = context.clone();
        CancellationFlag flag = new CancellationFlag();
        Task task = new Task(this.executor, asyncInterceptorContext, flag);
        asyncInterceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
        this.executor.execute(task);
        return task;
    }

    private static class Task
    extends AsyncFutureTask<Object>
    implements Runnable {
        private final InterceptorContext context;
        private final CancellationFlag flag;

        private Task(Executor executor, InterceptorContext context, CancellationFlag flag) {
            super(executor);
            this.context = context;
            this.flag = flag;
        }

        public void asyncCancel(boolean interruptionDesired) {
            if (interruptionDesired) {
                this.flag.set(true);
            }
        }

        @Override
        public void run() {
            Object result;
            try {
                result = this.context.proceed();
            }
            catch (Exception e) {
                this.setFailed(e);
                return;
            }
            Future asyncResult = (Future)result;
            try {
                result = asyncResult.get();
            }
            catch (InterruptedException e) {
                this.setFailed(new IllegalStateException(e));
                return;
            }
            catch (ExecutionException e) {
                try {
                    throw e.getCause();
                }
                catch (Exception ex) {
                    this.setFailed(ex);
                    return;
                }
                catch (Throwable throwable) {
                    this.setFailed(new UndeclaredThrowableException(throwable));
                    return;
                }
            }
            this.setResult(result);
        }
    }
}

