/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceBuilder;

public abstract class EJBComponentConfiguration
extends AbstractComponentConfiguration {
    private final TransactionManagementType transactionManagementType;
    private final ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs;

    public EJBComponentConfiguration(EJBComponentDescription description) {
        super((AbstractComponentDescription)description);
        description.addDependency(EJBUtilities.SERVICE_NAME, ServiceBuilder.DependencyType.REQUIRED);
        this.addCurrentInvocationContextInterceptorFactory();
        this.transactionManagementType = description.getTransactionManagementType();
        if (this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER)) {
            this.txAttrs = new ConcurrentHashMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>>();
            this.addComponentSystemInterceptorFactory((InterceptorFactory)new ComponentInterceptorFactory(){

                protected Interceptor create(Component component, InterceptorFactoryContext context) {
                    return new CMTTxInterceptor((TransactionalComponent)component);
                }
            });
        } else {
            this.txAttrs = null;
        }
    }

    protected void addComponentSystemInterceptorFactory(InterceptorFactory interceptorFactory) {
        super.getComponentSystemInterceptorFactories().add(interceptorFactory);
    }

    protected abstract void addCurrentInvocationContextInterceptorFactory();

    public String getName() {
        return this.getComponentName();
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> getTxAttrs() {
        return this.txAttrs;
    }
}

