/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public class ComponentInstanceInterceptor
extends AbstractEJBInterceptor {
    private static final Logger log = Logger.getLogger(ComponentInstanceInterceptor.class);

    public Object processInvocation(InterceptorContext context) throws Exception {
        StatefulSessionComponent component = ComponentInstanceInterceptor.getComponent(context, StatefulSessionComponent.class);
        Serializable sessionId = (Serializable)context.getPrivateData(Serializable.class);
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)component.getCache().get(sessionId);
        try {
            context.putPrivateData(ComponentInstance.class, (Object)instance);
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing bean " + sessionId + " because of exception"), (Throwable)ex);
                }
                component.getCache().discard(sessionId);
            }
            throw ex;
        }
        catch (Error e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing bean " + sessionId + " because of error"), (Throwable)e);
            }
            component.getCache().discard(sessionId);
            throw e;
        }
        catch (Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing bean " + sessionId + " because of Throwable"), t);
            }
            component.getCache().discard(sessionId);
            throw new RuntimeException(t);
        }
        finally {
            context.putPrivateData(ComponentInstance.class, null);
        }
    }

    static StatefulSessionComponentInstance getComponentInstance(InterceptorContext context) {
        return (StatefulSessionComponentInstance)((Object)context.getPrivateData(ComponentInstance.class));
    }
}

