/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.ee.component.LookupBindingSourceDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;
import org.jboss.msc.service.ServiceName;

public class EjbRefProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    protected List<BindingDescription> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, AbstractComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        EJBLocalReferencesMetaData ejbLocalRefs = environment.getEnvironment().getEjbLocalReferences();
        ArrayList<BindingDescription> bindingDescriptions = new ArrayList<BindingDescription>();
        if (ejbLocalRefs != null) {
            for (EJBLocalReferenceMetaData ejbRef : ejbLocalRefs) {
                String name = ejbRef.getEjbRefName();
                String ejbName = ejbRef.getLink();
                String lookup = ejbRef.getLookupName();
                String localInterface = ejbRef.getLocal();
                Class localInterfaceType = null;
                if (!this.isEmpty(localInterface)) {
                    try {
                        classLoader.loadClass(localInterface);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DeploymentUnitProcessingException("Could not load local interface type " + localInterface, (Throwable)e);
                    }
                }
                if (!name.startsWith("java:")) {
                    name = environment.getDefaultContext() + name;
                }
                BindingDescription bindingDescription = new BindingDescription(name);
                bindingDescriptions.add(bindingDescription);
                localInterfaceType = this.processInjectionTargets(classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)ejbRef, bindingDescription, localInterfaceType);
                if (localInterfaceType == null) {
                    throw new DeploymentUnitProcessingException("Could not determine type of ejb-local-ref " + name + " for component " + componentDescription);
                }
                bindingDescription.setBindingType(localInterfaceType.getName());
                if (!this.isEmpty(lookup)) {
                    if (componentDescription != null) {
                        bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, componentDescription));
                        continue;
                    }
                    bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, moduleDescription));
                    continue;
                }
                if (!this.isEmpty(ejbName)) {
                    ServiceName beanServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{ejbName}).append(new String[]{"VIEW"}).append(new String[]{bindingDescription.getBindingType()});
                    bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(beanServiceName));
                    continue;
                }
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LazyBindingSourceDescription());
            }
        }
        return bindingDescriptions;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

