/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.InjectionTargetDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.LazyBindingSourceDescription;
import org.jboss.as.ee.component.LookupBindingSourceDescription;
import org.jboss.as.ee.component.ServiceBindingSourceDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.msc.service.ServiceName;

public class EjbResourceInjectionAnnotationProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName EJB_ANNOTATION_NAME = DotName.createSimple((String)EJB.class.getName());

    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription description) throws DeploymentUnitProcessingException {
        ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)description.getComponentClassName()));
        if (classInfo == null) {
            return;
        }
        description.addAnnotationBindings(this.getEjbInjectionConfigurations(index, classInfo, deploymentUnit, description));
        Collection interceptorConfigurations = description.getAllInterceptors().values();
        for (InterceptorDescription interceptorConfiguration : interceptorConfigurations) {
            ClassInfo interceptorClassInfo = index.getClassByName(DotName.createSimple((String)interceptorConfiguration.getInterceptorClassName()));
            if (interceptorClassInfo == null) continue;
            description.addAnnotationBindings(this.getEjbInjectionConfigurations(index, interceptorClassInfo, deploymentUnit, description));
        }
    }

    private List<BindingDescription> getEjbInjectionConfigurations(CompositeIndex index, ClassInfo classInfo, DeploymentUnit deploymentUnit, AbstractComponentDescription componentDescription) {
        ClassInfo superClass;
        DotName superName;
        List ejbAnnotations;
        ArrayList<BindingDescription> configurations = new ArrayList<BindingDescription>();
        Map classAnnotations = classInfo.annotations();
        if (classAnnotations != null && (ejbAnnotations = (List)classAnnotations.get(EJB_ANNOTATION_NAME)) != null) {
            for (AnnotationInstance annotation : ejbAnnotations) {
                configurations.add(this.getEjbInjectionConfiguration(annotation, deploymentUnit, componentDescription));
            }
        }
        if ((superName = classInfo.superName()) != null && !superName.toString().equals(Object.class.getName()) && (superClass = index.getClassByName(superName)) != null) {
            configurations.addAll(this.getEjbInjectionConfigurations(index, superClass, deploymentUnit, componentDescription));
        }
        return configurations;
    }

    private BindingDescription getEjbInjectionConfiguration(AnnotationInstance annotation, DeploymentUnit deploymentUnit, AbstractComponentDescription componentDescription) {
        String lookup;
        AnnotationTarget annotationTarget = annotation.target();
        AnnotationValue nameValue = annotation.value("name");
        String name = nameValue != null ? nameValue.asString() : null;
        AnnotationValue beanNameValue = annotation.value("beanName");
        String beanName = beanNameValue != null ? beanNameValue.asString() : null;
        AnnotationValue beanInterfaceValue = annotation.value("beanInterface");
        String beanInterface = beanInterfaceValue != null ? beanInterfaceValue.asClass().name().toString() : null;
        AnnotationValue descriptionValue = annotation.value("description");
        String description = descriptionValue != null ? descriptionValue.asString() : null;
        AnnotationValue lookupValue = annotation.value("lookup");
        String string = lookup = lookupValue != null ? lookupValue.asString() : null;
        if (!this.isEmpty(lookup) && !this.isEmpty(beanName)) {
            throw new IllegalArgumentException("@EJB annotations may have either 'beanName' or 'lookup' specified, but not both");
        }
        BindingDescription bindingDescription = annotationTarget instanceof FieldInfo ? this.processFieldInjection((FieldInfo)FieldInfo.class.cast(annotationTarget), name, beanInterface, componentDescription) : (annotationTarget instanceof MethodInfo ? this.processMethodInjection((MethodInfo)MethodInfo.class.cast(annotationTarget), name, beanInterface, componentDescription) : (annotationTarget instanceof ClassInfo ? this.processClassInjection(name, beanInterface, componentDescription) : null));
        if (bindingDescription != null) {
            if (!this.isEmpty(description)) {
                bindingDescription.setDescription(description);
            }
            if (!this.isEmpty(lookup)) {
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LookupBindingSourceDescription(lookup, componentDescription));
            } else if (!this.isEmpty(beanName)) {
                ServiceName beanServiceName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{beanName}).append(new String[]{"VIEW"}).append(new String[]{bindingDescription.getBindingType()});
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new ServiceBindingSourceDescription(beanServiceName));
            } else {
                bindingDescription.setReferenceSourceDescription((BindingSourceDescription)new LazyBindingSourceDescription());
            }
        }
        return bindingDescription;
    }

    private BindingDescription processFieldInjection(FieldInfo fieldInfo, String name, String beanInterface, AbstractComponentDescription componentDescription) {
        String fieldName = fieldInfo.name();
        String injectionType = this.isEmpty(beanInterface) || beanInterface.equals(Object.class.getName()) ? fieldInfo.type().name().toString() : beanInterface;
        String localContextName = this.isEmpty(name) ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : name;
        BindingDescription bindingDescription = this.createBindingDescription(localContextName, injectionType, componentDescription);
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(fieldName);
        targetDescription.setClassName(fieldInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.FIELD);
        targetDescription.setValueClassName(injectionType);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processMethodInjection(MethodInfo methodInfo, String name, String beanInterface, AbstractComponentDescription componentDescription) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@EJB injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        String localContextName = this.isEmpty(name) ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : name;
        String injectionType = this.isEmpty(beanInterface) || beanInterface.equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : beanInterface;
        BindingDescription bindingDescription = this.createBindingDescription(localContextName, injectionType, componentDescription);
        InjectionTargetDescription targetDescription = new InjectionTargetDescription();
        targetDescription.setName(methodName);
        targetDescription.setClassName(methodInfo.declaringClass().name().toString());
        targetDescription.setType(InjectionTargetDescription.Type.METHOD);
        targetDescription.setValueClassName(injectionType);
        bindingDescription.getInjectionTargetDescriptions().add(targetDescription);
        return bindingDescription;
    }

    private BindingDescription processClassInjection(String name, String beanInterface, AbstractComponentDescription componentDescription) {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("Class level @EJB annotations must provide a name.");
        }
        if (this.isEmpty(beanInterface) || beanInterface.equals(Object.class.getName())) {
            throw new IllegalArgumentException("Class level @EJB annotations must provide a 'beanInterface'.");
        }
        return this.createBindingDescription(name, beanInterface, componentDescription);
    }

    private BindingDescription createBindingDescription(String name, String beanInterface, AbstractComponentDescription componentDescription) {
        BindingDescription bindingDescription = new BindingDescription(name, componentDescription);
        bindingDescription.setDependency(true);
        bindingDescription.setBindingType(beanInterface);
        return bindingDescription;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

