/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3;

import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.ejb3.EJB3SubsystemProviders;
import org.jboss.as.ejb3.Ejb3SubsystemAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EJB3Extension
implements Extension {
    public static final String SUBSYSTEM_NAME = "ejb3";
    public static final String NAMESPACE = "urn:jboss:domain:ejb3:1.0";
    private static final EJB3SubsystemParser parser = new EJB3SubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(EJB3SubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)Ejb3SubsystemAdd.INSTANCE, EJB3SubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)SubsystemDescribeHandler.INSTANCE, (DescriptionProvider)SubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)parser);
    }

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    private static class SubsystemDescribeHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        static final SubsystemDescribeHandler INSTANCE = new SubsystemDescribeHandler();

        private SubsystemDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode node = new ModelNode();
            node.add(EJB3Extension.createAddSubSystemOperation());
            resultHandler.handleResultFragment(Util.NO_LOCATION, node);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    }

    static class EJB3SubsystemParser
    implements XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        EJB3SubsystemParser() {
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(EJB3Extension.NAMESPACE, false);
            writer.writeEndElement();
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ModelNode update = new ModelNode();
            update.get("operation").set("add");
            update.get("address").add("subsystem", EJB3Extension.SUBSYSTEM_NAME);
            list.add(update);
        }
    }
}

