/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.ejb.AccessTimeout;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInjector;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.AsyncFutureInterceptor;
import org.jboss.as.ejb3.component.AsyncVoidInterceptor;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.session.SessionBeanComponentConfiguration;
import org.jboss.as.ejb3.component.session.SessionBeanComponentInstance;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.base.BaseSessionInvocationContext;
import org.jboss.ejb3.context.spi.EJBContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.context.spi.SessionContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public abstract class SessionBeanComponent
extends EJBComponent
implements org.jboss.ejb3.context.spi.SessionBeanComponent {
    private static final Logger logger = Logger.getLogger(SessionBeanComponent.class);
    static final ServiceName ASYNC_EXECUTOR_SERVICE_NAME = ThreadsServices.EXECUTOR.append(new String[]{"ejb3-async"});
    protected AccessTimeout beanLevelAccessTimeout;
    private final Set<Method> asynchronousMethods;
    protected Executor asyncExecutor;

    protected SessionBeanComponent(SessionBeanComponentConfiguration configuration) {
        super(configuration);
        AccessTimeout accessTimeout = configuration.getBeanLevelAccessTimeout();
        if (accessTimeout == null) {
            accessTimeout = new AccessTimeout(){

                public long value() {
                    return 5L;
                }

                public TimeUnit unit() {
                    return TimeUnit.MINUTES;
                }

                public Class<? extends Annotation> annotationType() {
                    return AccessTimeout.class;
                }
            };
        }
        this.beanLevelAccessTimeout = accessTimeout;
        this.asynchronousMethods = configuration.getAsynchronousMethods();
        this.asyncExecutor = (Executor)configuration.getInjection(ASYNC_EXECUTOR_SERVICE_NAME).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ComponentInjector.InjectionHandle> applyInjections(ComponentInstance instance) {
        BaseSessionInvocationContext invocationContext = new BaseSessionInvocationContext(null, null, null){

            public Object proceed() throws Exception {
                throw new RuntimeException("Do not call proceed");
            }
        };
        invocationContext.setEJBContext((EJBContext)((SessionBeanComponentInstance)instance).getSessionContext());
        CurrentInvocationContext.push((InvocationContext)invocationContext);
        try {
            List list = super.applyInjections(instance);
            return list;
        }
        finally {
            CurrentInvocationContext.pop();
        }
    }

    public <T> T getBusinessObject(SessionContext ctx, Class<T> businessInterface) throws IllegalStateException {
        ComponentView view = this.getComponentView(businessInterface);
        if (view == null) {
            throw new IllegalStateException("Stateful bean " + this.getComponentName() + " does not have a view " + businessInterface);
        }
        Serializable sessionId = ((SessionBeanComponentInstance.SessionBeanComponentInstanceContext)ctx).getId();
        Object proxy = view.getViewForInstance(sessionId);
        return businessInterface.cast(proxy);
    }

    public EJBLocalObject getEJBLocalObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBLocalObject");
    }

    public EJBObject getEJBObject(SessionContext ctx) throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.session.SessionBeanComponent.getEJBObject");
    }

    public AccessTimeout getAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public Executor getAsynchronousExecutor() {
        return this.asyncExecutor;
    }

    protected boolean isAsynchronous(Method method) {
        Set<Method> asyncMethods = this.asynchronousMethods;
        if (asyncMethods == null) {
            return false;
        }
        for (Method asyncMethod : asyncMethods) {
            Object[] asyncMethodParams;
            Object[] methodParams;
            if (!method.getName().equals(asyncMethod.getName()) || !Arrays.equals(methodParams = method.getParameterTypes(), asyncMethodParams = asyncMethod.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    public abstract Object invoke(Serializable var1, Map<String, Object> var2, Class<?> var3, Method var4, Object[] var5) throws Exception;

    protected Object invokeAsynchronous(Method method, InterceptorContext context) throws Exception {
        if (Void.TYPE.isAssignableFrom(method.getReturnType())) {
            return new AsyncVoidInterceptor(this.getAsynchronousExecutor()).processInvocation(context);
        }
        return new AsyncFutureInterceptor(this.getAsynchronousExecutor()).processInvocation(context);
    }

    public Interceptor createClientInterceptor(Class<?> view, Serializable sessionId) {
        return this.createClientInterceptor(view);
    }

    public Interceptor createClientInterceptor(final Class<?> view) {
        return new Interceptor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processInvocation(InterceptorContext context) throws Exception {
                Method method = context.getMethod();
                if (SessionBeanComponent.this.getComponentClass().equals(view) && !SessionBeanComponent.this.isInvocationAllowed(method)) {
                    throw new EJBException("Cannot invoke method " + method + " on nointerface view of bean " + SessionBeanComponent.this.getComponentName());
                }
                context.putPrivateData(Component.class, (Object)SessionBeanComponent.this);
                try {
                    if (SessionBeanComponent.this.isAsynchronous(method)) {
                        Object object = SessionBeanComponent.this.invokeAsynchronous(method, context);
                        return object;
                    }
                    Object object = context.proceed();
                    return object;
                }
                finally {
                    context.putPrivateData(Component.class, null);
                }
            }
        };
    }

    protected boolean isInvocationAllowed(Method method) {
        int m = method.getModifiers();
        if (!Modifier.isPublic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is *not* public"));
            }
            return false;
        }
        if (Modifier.isFinal(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is final"));
            }
            return false;
        }
        if (Modifier.isStatic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is static"));
            }
            return false;
        }
        if (Modifier.isNative(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is native"));
            }
            return false;
        }
        return true;
    }
}

