/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.AccessTimeout;
import javax.ejb.TimerService;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.ExpiringCache;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.naming.ManagedReference;
import org.jboss.ejb3.cache.Cache;
import org.jboss.ejb3.cache.StatefulObjectFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.TxUtils;

public class StatefulSessionComponent
extends SessionBeanComponent {
    public static final Object SESSION_ATTACH_KEY = new Object();
    private Cache<StatefulSessionComponentInstance> cache;
    private static final Logger logger = Logger.getLogger(StatefulSessionComponent.class);
    final InterceptorFactory afterBegin;
    final InterceptorFactory afterCompletion;
    final InterceptorFactory beforeCompletion;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;

    protected StatefulSessionComponent(StatefulSessionComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.afterBegin = ejbComponentCreateService.getAfterBegin();
        this.afterCompletion = ejbComponentCreateService.getAfterCompletion();
        this.beforeCompletion = ejbComponentCreateService.getBeforeCompletion();
        this.methodAccessTimeouts = ejbComponentCreateService.getMethodApplicableAccessTimeouts();
        StatefulTimeoutInfo statefulTimeout = ejbComponentCreateService.getStatefulTimeout();
        this.cache = statefulTimeout != null ? new ExpiringCache<StatefulSessionComponentInstance>(statefulTimeout.getValue(), statefulTimeout.getTimeUnit(), ejbComponentCreateService.getComponentClass().getName()) : new ExpiringCache<StatefulSessionComponentInstance>(-1L, TimeUnit.MILLISECONDS, ejbComponentCreateService.getComponentClass().getName());
        this.cache.setStatefulObjectFactory((StatefulObjectFactory)new StatefulObjectFactory<StatefulSessionComponentInstance>(){

            public StatefulSessionComponentInstance createInstance() {
                return (StatefulSessionComponentInstance)StatefulSessionComponent.this.createInstance();
            }

            public void destroyInstance(StatefulSessionComponentInstance instance) {
                instance.destroy();
            }
        });
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        throw new IllegalStateException("TimerService is not supported for Stateful session bean " + this.getComponentName());
    }

    public AccessTimeout getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeout accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeout timeout = (AccessTimeout)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (timeout != null) {
            return timeout;
        }
        return new AccessTimeout(){

            public long value() {
                return 5L;
            }

            public TimeUnit unit() {
                return TimeUnit.MINUTES;
            }

            public Class<? extends Annotation> annotationType() {
                return AccessTimeout.class;
            }
        };
    }

    protected Interceptor createInterceptor(InterceptorFactory factory) {
        if (factory == null) {
            return null;
        }
        SimpleInterceptorFactoryContext context = new SimpleInterceptorFactoryContext();
        context.getContextData().put(Component.class, this);
        return factory.create((InterceptorFactoryContext)context);
    }

    public Serializable createSession() {
        return ((StatefulSessionComponentInstance)this.getCache().create()).getId();
    }

    public Cache<StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        return new StatefulSessionComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors);
    }

    public void removeSession(Serializable sessionId) {
        Transaction currentTx = null;
        try {
            currentTx = this.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (currentTx != null && TxUtils.isActive((Transaction)currentTx)) {
            try {
                currentTx.registerSynchronization((Synchronization)new RemoveSynchronization(this, sessionId));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.getCache().remove(sessionId);
        }
    }

    public void start() {
        super.start();
        this.cache.start();
    }

    public void stop(StopContext stopContext) {
        super.stop(stopContext);
        this.cache.stop();
    }

    private static class RemoveSynchronization
    implements Synchronization {
        private final StatefulSessionComponent statefulComponent;
        private final Serializable sessionId;

        public RemoveSynchronization(StatefulSessionComponent component, Serializable sessionId) {
            if (sessionId == null) {
                throw new IllegalArgumentException("Session id cannot be null");
            }
            if (component == null) {
                throw new IllegalArgumentException("Stateful component cannot be null");
            }
            this.sessionId = sessionId;
            this.statefulComponent = component;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.statefulComponent.getCache().remove(this.sessionId);
            }
            catch (Throwable t) {
                logger.error((Object)("Failed to remove bean: " + this.statefulComponent.getComponentName() + " with session id " + this.sessionId), t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

