/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.security.DenyAll;
import org.jboss.as.ejb3.EJBMethodIdentifier;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class DenyAllProcessor
extends AbstractAnnotationEJBProcessor<EJBComponentDescription> {
    private static final DotName DENY_ALL_DOT_NAME = DotName.createSimple((String)DenyAll.class.getName());
    private static final Logger logger = Logger.getLogger(DenyAllProcessor.class);

    @Override
    protected Class<EJBComponentDescription> getComponentDescriptionType() {
        return EJBComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex index, EJBComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ClassInfo klass = beanClass;
        while (klass != null) {
            Map annotationsOnBean = klass.annotations();
            if (annotationsOnBean == null || annotationsOnBean.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            List denyAllAnnotations = (List)annotationsOnBean.get(DENY_ALL_DOT_NAME);
            if (denyAllAnnotations == null || denyAllAnnotations.isEmpty()) {
                klass = this.getSuperClass(klass, index);
                continue;
            }
            for (AnnotationInstance denyAllAnnotation : denyAllAnnotations) {
                AnnotationTarget target = denyAllAnnotation.target();
                if (target instanceof ClassInfo) {
                    componentDescription.applyDenyAllOnAllViewsForClass(((ClassInfo)target).name().toString());
                    continue;
                }
                if (!(target instanceof MethodInfo)) continue;
                MethodInfo methodInfo = (MethodInfo)target;
                EJBMethodIdentifier ejbMethodIdentifier = EJBMethodIdentifier.fromMethodInfo(methodInfo);
                componentDescription.applyDenyAllOnAllViewsForMethod(ejbMethodIdentifier);
            }
            klass = this.getSuperClass(klass, index);
        }
    }
}

