/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ejb3.component.ArrayKey;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.spi.InvocationContext;
import org.jboss.ejb3.tx2.spi.TransactionalComponent;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;

public abstract class EJBComponent
extends BasicComponent
implements org.jboss.ejb3.context.spi.EJBComponent,
TransactionalComponent {
    private static Logger log = Logger.getLogger(EJBComponent.class);
    private final ConcurrentMap<MethodIntf, ConcurrentMap<String, ConcurrentMap<ArrayKey, TransactionAttributeType>>> txAttrs;
    private final EJBUtilities utilities;
    private final boolean isBeanManagedTransaction;
    private static volatile boolean youHaveBeenWarnedEJBTHREE2120 = false;
    private final Map<Class<?>, ApplicationException> applicationExceptions;
    private final EJBSecurityMetaData securityMetaData;

    protected EJBComponent(EJBComponentCreateService ejbComponentCreateService) {
        super((BasicComponentCreateService)ejbComponentCreateService);
        this.applicationExceptions = Collections.unmodifiableMap(ejbComponentCreateService.getEjbJarConfiguration().getApplicationExceptions());
        DeploymentUnit deploymentUnit = (DeploymentUnit)ejbComponentCreateService.getDeploymentUnitInjector().getValue();
        ServiceController serviceController = deploymentUnit.getServiceRegistry().getRequiredService(EJBUtilities.SERVICE_NAME);
        this.utilities = (EJBUtilities)serviceController.getValue();
        this.txAttrs = ejbComponentCreateService.getTxAttrs();
        this.isBeanManagedTransaction = TransactionManagementType.BEAN.equals((Object)ejbComponentCreateService.getTransactionManagementType());
        this.securityMetaData = ejbComponentCreateService.getSecurityMetaData();
    }

    public ApplicationException getApplicationException(Class<?> exceptionClass) {
        ApplicationException applicationException = this.applicationExceptions.get(exceptionClass);
        if (applicationException != null) {
            return applicationException;
        }
        for (Class<?> superClass = exceptionClass.getSuperclass(); superClass != null && !superClass.equals(Exception.class) && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            applicationException = this.applicationExceptions.get(superClass);
            if (applicationException == null) continue;
            if (applicationException.inherited()) {
                return applicationException;
            }
            return null;
        }
        return null;
    }

    public Principal getCallerPrincipal() {
        return this.utilities.getSecurityManager().getCallerPrincipal();
    }

    protected TransactionAttributeType getCurrentTransactionAttribute() {
        InvocationContext currentInvocationContext = CurrentInvocationContext.get();
        if (currentInvocationContext == null) {
            return null;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        if (invokedMethod == null) {
            return null;
        }
        return this.getTransactionAttributeType(invokedMethod);
    }

    public EJBHome getEJBHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBHome");
    }

    public EJBLocalHome getEJBLocalHome() throws IllegalStateException {
        throw new RuntimeException("NYI: org.jboss.as.ejb3.component.EJBComponent.getEJBLocalHome");
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use getRollbackOnly.");
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current transaction status is " + status));
            }
            switch (status) {
                case 3: 
                case 4: {
                    throw new IllegalStateException("getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)");
                }
                case 1: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException se) {
            log.warn((Object)"failed to get tx manager status; ignoring", (Throwable)se);
            return true;
        }
    }

    public SimpleSecurityManager getSecurityManager() {
        return this.utilities.getSecurityManager();
    }

    public TimerService getTimerService() throws IllegalStateException {
        return new NonFunctionalTimerService();
    }

    @Deprecated
    public TransactionAttributeType getTransactionAttributeType(Method method) {
        if (!youHaveBeenWarnedEJBTHREE2120) {
            log.warn((Object)"EJBTHREE-2120: deprecated getTransactionAttributeType method called (dev problem)");
            youHaveBeenWarnedEJBTHREE2120 = true;
        }
        return this.getTransactionAttributeType(MethodIntf.BEAN, method);
    }

    public TransactionAttributeType getTransactionAttributeType(MethodIntf methodIntf, Method method) {
        ConcurrentMap perMethodIntf = (ConcurrentMap)this.txAttrs.get((Object)methodIntf);
        if (perMethodIntf == null) {
            throw new IllegalStateException("Can't find tx attrs for view type " + (Object)((Object)methodIntf) + " on bean named " + this.getComponentName());
        }
        ConcurrentMap perMethod = (ConcurrentMap)perMethodIntf.get(method.getName());
        if (perMethod == null) {
            throw new IllegalStateException("Can't find tx attrs for method name " + method.getName() + " on view type " + (Object)((Object)methodIntf) + " on bean named " + this.getComponentName());
        }
        TransactionAttributeType txAttr = (TransactionAttributeType)perMethod.get(new ArrayKey(method.getParameterTypes()));
        if (txAttr == null) {
            throw new IllegalStateException("Can't find tx attr for method " + method + " on view type " + (Object)((Object)methodIntf) + " on bean named " + this.getComponentName());
        }
        return txAttr;
    }

    public TransactionManager getTransactionManager() {
        return this.utilities.getTransactionManager();
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.utilities.getTransactionSynchronizationRegistry();
    }

    public int getTransactionTimeout(Method method) {
        return -1;
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (!this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 4.3.3 & 5.4.5 Only beans with bean-managed transaction demarcation can use this method.");
        }
        return this.utilities.getUserTransaction();
    }

    private boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isCallerInRole(String roleName) throws IllegalStateException {
        return this.utilities.getSecurityManager().isCallerInRole(new String[]{roleName});
    }

    @Deprecated
    public boolean isCallerInRole(Principal callerPrincipal, String roleName) throws IllegalStateException {
        return this.isCallerInRole(roleName);
    }

    public Object lookup(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("jndi name cannot be null during lookup");
        }
        NamespaceContextSelector namespaceContextSelector = NamespaceContextSelector.getCurrentSelector();
        if (namespaceContextSelector == null) {
            throw new IllegalStateException("No NamespaceContextSelector available, cannot lookup " + name);
        }
        Context jndiContext = null;
        String namespaceStrippedJndiName = name;
        if (name.startsWith("java:app/")) {
            jndiContext = namespaceContextSelector.getContext("app");
            namespaceStrippedJndiName = name.substring("java:app/".length());
        } else if (name.startsWith("java:module/")) {
            jndiContext = namespaceContextSelector.getContext("module");
            namespaceStrippedJndiName = name.substring("java:module/".length());
        } else if (name.startsWith("java:comp/")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = name.substring("java:comp/".length());
        } else if (!name.startsWith("java:")) {
            jndiContext = namespaceContextSelector.getContext("comp");
            namespaceStrippedJndiName = "env/" + name;
        } else if (name.startsWith("java:global/")) {
            try {
                jndiContext = new InitialContext();
            }
            catch (NamingException ne) {
                throw new RuntimeException("Could not lookup jndi name: " + name, ne);
            }
        } else {
            throw new IllegalArgumentException("Cannot lookup jndi name: " + name + " since it" + " doesn't belong to java:app, java:module, java:comp or java:global namespace");
        }
        log.debug((Object)("Looking up " + namespaceStrippedJndiName + " in jndi context: " + jndiContext));
        try {
            return jndiContext.lookup(namespaceStrippedJndiName);
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("Could not lookup jndi name: " + namespaceStrippedJndiName + " in context: " + jndiContext, ne);
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (this.isBeanManagedTransaction()) {
            throw new IllegalStateException("EJB 3.1 FR 13.6.1 Only beans with container-managed transaction demarcation can use setRollbackOnly.");
        }
        try {
            TransactionManager tm = this.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException se) {
            log.warn((Object)"failed to set rollback only; ignoring", (Throwable)se);
        }
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    private class NonFunctionalTimerService
    implements TimerService {
        private final UnsupportedOperationException UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("This is a temporary non-functional timerservice. No operations are allowed on it.");

        private NonFunctionalTimerService() {
        }

        public Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }

        public Collection<Timer> getTimers() throws IllegalStateException, EJBException {
            throw this.UNSUPPORTED_OPERATION_EXCEPTION;
        }
    }
}

