/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.TCCLInterceptor;
import org.jboss.as.ejb3.PrimitiveClassLoaderUtil;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.session.SessionInvocationContextInterceptor;
import org.jboss.as.ejb3.component.stateful.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.stateful.MethodDescription;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;

public class StatefulSessionComponentCreateService
extends SessionBeanComponentCreateService {
    private final InterceptorFactory afterBegin;
    private final InterceptorFactory afterCompletion;
    private final InterceptorFactory beforeCompletion;
    private final StatefulTimeoutInfo statefulTimeout;

    public StatefulSessionComponentCreateService(ComponentConfiguration componentConfiguration, EjbJarConfiguration ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new TCCLInterceptor(componentConfiguration.getComponentClass().getClassLoader()));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        Class beanClass = componentConfiguration.getComponentClass();
        this.afterBegin = StatefulSessionComponentCreateService.interceptorFactoryChain(new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, SessionInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(beanClass, componentDescription.getAfterBegin())});
        this.afterCompletion = StatefulSessionComponentCreateService.interceptorFactoryChain(new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, SessionInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(beanClass, componentDescription.getAfterCompletion())});
        this.beforeCompletion = StatefulSessionComponentCreateService.interceptorFactoryChain(new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, SessionInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(beanClass, componentDescription.getBeforeCompletion())});
        this.statefulTimeout = componentDescription.getStatefulTimeout();
    }

    private static InterceptorFactory invokeMethodOnTarget(Class<?> beanClass, MethodDescription methodDescription) {
        Method method = StatefulSessionComponentCreateService.methodOf(beanClass, methodDescription);
        if (method == null) {
            return null;
        }
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    private static InterceptorFactory interceptorFactoryChain(InterceptorFactory ... factories) {
        if (factories[factories.length - 1] == null) {
            return null;
        }
        return Interceptors.getChainedInterceptorFactory((InterceptorFactory[])factories);
    }

    protected BasicComponent createComponent() {
        return new StatefulSessionComponent(this);
    }

    private static Method declaredMethodOfHierarchy(Class<?> cls, String name, Class<?>[] parameterTypes) {
        if (cls == null) {
            throw new RuntimeException("Unable to find method " + name + " " + Arrays.toString(parameterTypes));
        }
        try {
            return cls.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return StatefulSessionComponentCreateService.declaredMethodOfHierarchy(cls.getSuperclass(), name, parameterTypes);
        }
    }

    private static Method methodOf(Class<?> cls, MethodDescription methodDescription) {
        if (methodDescription == null) {
            return null;
        }
        try {
            ClassLoader classLoader = cls.getClassLoader();
            String[] types = methodDescription.params;
            Class[] paramTypes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                paramTypes[i] = PrimitiveClassLoaderUtil.loadClass(types[i], classLoader);
            }
            if (methodDescription.className != null) {
                Class<?> declaringClass = Class.forName(methodDescription.className, false, classLoader);
                return declaringClass.getDeclaredMethod(methodDescription.methodName, paramTypes);
            }
            return StatefulSessionComponentCreateService.declaredMethodOfHierarchy(cls, methodDescription.methodName, paramTypes);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public StatefulTimeoutInfo getStatefulTimeout() {
        return this.statefulTimeout;
    }
}

