/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import java.util.Map;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.processors.AbstractAnnotationEJBProcessor;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class LockAnnotationProcessor
extends AbstractAnnotationEJBProcessor<SessionBeanComponentDescription> {
    private static final DotName LOCK_ANNOTATION_DOT_NAME = DotName.createSimple((String)Lock.class.getName());
    private static final Logger logger = Logger.getLogger(LockAnnotationProcessor.class);

    @Override
    protected Class<SessionBeanComponentDescription> getComponentDescriptionType() {
        return SessionBeanComponentDescription.class;
    }

    @Override
    protected void processAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        if (!componentDescription.allowsConcurrentAccess()) {
            return;
        }
        if (componentDescription.getConcurrencyManagementType() == ConcurrencyManagementType.BEAN) {
            logger.debug((Object)("Skipping @Lock processing for bean: " + componentDescription.getEJBName() + " with BEAN managed concurrency management"));
            return;
        }
        this.processLockAnnotations(beanClass, compositeIndex, componentDescription);
    }

    private void processLockAnnotations(ClassInfo beanClass, CompositeIndex compositeIndex, SessionBeanComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        Map classAnnotations;
        ClassInfo superClass;
        DotName superName = beanClass.superName();
        if (superName != null && (superClass = compositeIndex.getClassByName(superName)) != null) {
            this.processLockAnnotations(superClass, compositeIndex, componentDescription);
        }
        if ((classAnnotations = beanClass.annotations()) == null) {
            return;
        }
        List annotations = (List)classAnnotations.get(LOCK_ANNOTATION_DOT_NAME);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotationInstance : annotations) {
            AnnotationTarget target = annotationInstance.target();
            LockType lockType = LockType.valueOf((String)annotationInstance.value().asEnum());
            if (target instanceof ClassInfo) {
                componentDescription.setBeanLevelLockType(((ClassInfo)target).name().toString(), lockType);
                logger.debug((Object)("Bean " + componentDescription.getEJBName() + " marked for lock type " + lockType));
                continue;
            }
            if (!(target instanceof MethodInfo)) continue;
            MethodInfo method = (MethodInfo)target;
            MethodInfo methodInfo = (MethodInfo)target;
            String[] argTypes = new String[methodInfo.args().length];
            int i = 0;
            for (Type argType : methodInfo.args()) {
                argTypes[i++] = argType.name().toString();
            }
            MethodIdentifier identifier = MethodIdentifier.getIdentifier((String)methodInfo.returnType().name().toString(), (String)methodInfo.name(), (String[])argTypes);
            componentDescription.setLockType(lockType, identifier);
        }
    }
}

