/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBUtilities;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.deployment.EjbJarConfiguration;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class EJBComponentCreateService
extends BasicComponentCreateService {
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final TransactionManagementType transactionManagementType;
    private final EjbJarConfiguration ejbJarConfiguration;
    private final Map<String, ServiceName> viewServices;
    private final EJBSecurityMetaData securityMetaData;
    private final TimerService timerService;

    public EJBComponentCreateService(ComponentConfiguration componentConfiguration, EjbJarConfiguration ejbJarConfiguration) {
        super(componentConfiguration);
        this.ejbJarConfiguration = ejbJarConfiguration;
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.transactionManagementType = ejbComponentDescription.getTransactionManagementType();
        this.timerService = ejbComponentDescription.getTimerService();
        this.txAttrs = this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER) ? new HashMap<MethodTransactionAttributeKey, TransactionAttributeType>() : null;
        this.securityMetaData = new EJBSecurityMetaData(componentConfiguration);
        List views = componentConfiguration.getViews();
        if (views != null) {
            for (ViewConfiguration view : views) {
                EJBViewConfiguration ejbView = (EJBViewConfiguration)view;
                MethodIntf viewType = ejbView.getMethodIntf();
                for (Method method : view.getProxyFactory().getCachedMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    Method componentMethod = EJBComponentCreateService.getComponentMethod(componentConfiguration, method.getName(), method.getParameterTypes());
                    this.processTxAttr(ejbComponentDescription, viewType, componentMethod);
                }
            }
        }
        for (Method method : componentConfiguration.getComponentClass().getMethods()) {
            this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
        }
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : componentConfiguration.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.viewServices = viewServices;
    }

    private static Method getComponentMethod(ComponentConfiguration componentConfiguration, String name, Class<?>[] parameterTypes) {
        try {
            return componentConfiguration.getComponentClass().getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected EJBUtilities getEJBUtilities() {
        DeploymentUnit deploymentUnit = (DeploymentUnit)this.getDeploymentUnitInjector().getValue();
        ServiceController serviceController = deploymentUnit.getServiceRegistry().getRequiredService(EJBUtilities.SERVICE_NAME);
        return (EJBUtilities)serviceController.getValue();
    }

    Map<MethodTransactionAttributeKey, TransactionAttributeType> getTxAttrs() {
        return this.txAttrs;
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    EjbJarConfiguration getEjbJarConfiguration() {
        return this.ejbJarConfiguration;
    }

    protected void processTxAttr(EJBComponentDescription ejbComponentDescription, MethodIntf methodIntf, Method method) {
        String methodName;
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        String className = method.getDeclaringClass().getName();
        TransactionAttributeType txAttr = ejbComponentDescription.getTransactionAttribute(methodIntf, className, methodName = method.getName(), EJBComponentCreateService.toString(method.getParameterTypes()));
        if (txAttr != TransactionAttributeType.REQUIRED) {
            this.txAttrs.put(new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method)), txAttr);
        }
    }

    private static String[] toString(Class<?>[] a) {
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].getName();
        }
        return result;
    }

    public Map<String, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }
}

