/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.ApplicationException;
import org.jboss.as.ejb3.deployment.EjbJarDescription;

public class EjbJarConfiguration {
    private Map<Class<?>, ApplicationException> applicationExceptions = new HashMap();

    public EjbJarConfiguration(EjbJarDescription deploymentDescription) {
    }

    public ApplicationException getApplicationException(Class<?> exceptionClass) {
        return this.applicationExceptions.get(exceptionClass);
    }

    public Map<Class<?>, ApplicationException> getApplicationExceptions() {
        return Collections.unmodifiableMap(this.applicationExceptions);
    }

    public void addApplicationException(Class<?> exceptionClass, ApplicationException applicationException) {
        if (exceptionClass == null) {
            throw new IllegalArgumentException("Exception class cannot be null");
        }
        if (applicationException == null) {
            throw new IllegalArgumentException("ApplicationException cannot be null");
        }
        if (!Exception.class.isAssignableFrom(exceptionClass)) {
            throw new IllegalArgumentException("[EJB 3.1 spec, section 14.1.1] Class: " + exceptionClass + " cannot be " + "marked as an application exception because it is not of type " + Exception.class.getName());
        }
        if (RemoteException.class.isAssignableFrom(exceptionClass)) {
            throw new IllegalArgumentException("[EJB 3.1 spec, section 14.1.1] Exception class: " + exceptionClass + " cannot be marked as an " + "application exception because it is of type " + RemoteException.class.getName());
        }
        this.applicationExceptions.put(exceptionClass, applicationException);
    }
}

